<?php
/**
 * @var $message_id
 * @var $interlocutor_id
 */
?>

<div class="search-messages-result-wrapper js-search-messages-result" data-id="<?php echo $message_id; ?>">

	<?php // Messages before current message
	wpj_display_messages_list( array(
		'user1'                 => get_current_user_id(),
		'user2'                 => $interlocutor_id,
		'message_type'          => 'all',
		'display_location'      => 'pm',
		'query_params'          => ' AND id < ' . $message_id . ' ',
		'display_empty_message' => false,
		'limit'                 => wpj_get_option( 'wpjobster_message_search_results_number' ) ? wpj_get_option( 'wpjobster_message_search_results_number' ) : 2,
		'skip_search'           => true
	) ); ?>

	<div class="search-message-selected">

		<?php // Current message
		wpj_display_messages_list( array(
			'user1'                 => get_current_user_id(),
			'user2'                 => $interlocutor_id,
			'message_type'          => $message_id,
			'display_location'      => 'pm',
			'display_empty_message' => false,
			'limit'                 => 1,
			'load_type'             => 'hidden',
			'skip_search'           => true
		) ); ?>

	</div>

	<?php // Messages after current message
	wpj_display_messages_list( array(
		'user1'                 => get_current_user_id(),
		'user2'                 => $interlocutor_id,
		'message_type'          => 'all',
		'display_location'      => 'pm',
		'query_params'          => ' AND id > ' . $message_id . ' ',
		'display_empty_message' => false,
		'limit'                 => wpj_get_option( 'wpjobster_message_search_results_number' ) ? wpj_get_option( 'wpjobster_message_search_results_number' ) : 2,
		'row_extra_classes'     => 'not-reverse-order',
		'load_type'             => 'icon-down',
		'skip_search'           => true
	) ); ?>

</div>