<?php
/**
 * @var $messages
 * @var $i
 * @var $uid
 */
?>

<div class="antiscroll-wrap">

	<div class="antiscroll-inner">

		<?php if ( count( $messages ) > 0 ) {

			foreach ( $messages as $row ) { $i++;

				$initiator_arr = get_userdata( $row->initiator );

				if ( is_object( $initiator_arr ) && isset( $initiator_arr->ID ) ) {

					$user_login = wpj_get_user_display_type( $initiator_arr->ID );
					$user_link  = $initiator_arr->user_nicename;

				} else {

					$user_login = __( 'Deleted User', 'wpjobster' );
					$user_link  = $row->initiator;

				}

				$message = wpj_nl_to_space( strip_tags( html_entity_decode( htmlspecialchars_decode( $row->content ) ) ) );

				if ( $i == 1 ) { ?><ul><?php } ?>

					<li class="<?php echo $row->user == $uid && $row->rd == 0 ? 'unread' : 'read'; ?>">

						<a class="pm-preview-link" onclick="return wpj_chat_open_box( '<?php echo $row->initiator; ?>', event );" href="<?php echo wpj_get_pm_link( $user_link ); ?>">

							<div class="nh-notification-icon" style="background: transparent;">

								<?php wpj_display_user_photo( array( 'uid' => $row->initiator, 'width' => 45, 'height' => 45, 'with_level_image' => false, 'with_link' => false ) ); ?>

							</div>

							<div class="nh-notification-right">

								<div class="nh-notification-username">

									<?php echo $user_login . ( $row->user == $uid && $row->rd == 0 ? ' (' . wpj_get_pm_notify( 'COUNT( * )', ['initiator' => $row->initiator, 'user' => $row->user, 'show_to_source' => 1, 'rd' => 0], 'var' ) . ')' : '' ); ?>

								</div>

								<div class="nh-notification-content overflow-ellipsis">

									<?php echo strlen( $message ) > 80 ? wpj_apply_filter_to_string( mb_substr( $message, 0, 80 ), false, 'privatemessages' ) . "..." : wpj_apply_filter_to_string( $message, false, 'privatemessages' ); ?>

								</div>

								<div class="nh-notification-date">

									<?php echo wpj_date( wpj_get_option( 'date_format' ), $row->datemade ); ?>

								</div>

							</div>

						</a>

					</li>

			<?php }

			if ( $i >= 1 ) { ?>

				</ul>

			<?php } else { ?>

				<p><?php _e( "You don't have any unread messages.", "wpjobster" ); ?></p>

			<?php }

		} else { ?>

			<p><?php _e( "You don't have any unread messages.", "wpjobster" ); ?></p>

		<?php } ?>

	</div>

	<div class="wpj-view-all-cnt">

		<a href="<?php echo wpj_get_pm_link(); ?>"><?php _e( 'View all messages', 'wpjobster' ); ?></a>

	</div>

</div>