<?php
/**
 * @var $username
 * @var $dropdown_icon
 * @var $quick_responses
 * @var $uid
 */
?>

<div class="quick-response-wrapper">

	<!-- Dropdown -->
	<div class="ui bottom right pointing search dropdown without-rotation full-text-search quick-response-dropdown" data-uid="<?php echo $uid; ?>" data-username="<?php echo $username; ?>">

		<i class="<?php echo $dropdown_icon; ?> icon message-box-quick-response-icon"></i>

		<div class="menu">

			<div class="ui left search icon input">
				<i class="search icon"></i>
				<input type="text" placeholder="<?php _e( 'Search...', 'wpjobster' ); ?>">
			</div>

			<div class="header">
				<i class="edit icon"></i>
				<span id="new-quick-response" class="new-quick-response" data-uid="<?php echo $uid; ?>"><?php _e( 'Create a new quick response', 'wpjobster' ); ?></span>
			</div>

			<div class="header" id="delete-all-quick-responses-wrapper" <?php if ( ! $quick_responses ) { ?>style="display: none;" <?php } ?>>
				<i class="close icon"></i>
				<span id="delete-all-quick-responses" class="delete-all-quick-responses" data-uid="<?php echo $uid; ?>"><?php _e( 'Delete all quick responses', 'wpjobster' ); ?></span>
			</div>

			<?php if ( $quick_responses ) {

				foreach ( array_reverse( $quick_responses, true ) as $key => $response ) { ?>

					<div class="item" data-id="<?php echo $key; ?>">

						<span><?php echo wpj_trim( $response['name'], 23 ); ?></span>

						<div class="action-buttons float-right">
							<i data-id="<?php echo $key; ?>" data-uid="<?php echo $uid; ?>" id="edit-quick-response" class="edit icon"></i>
							<i data-id="<?php echo $key; ?>" data-uid="<?php echo $uid; ?>" id="remove-quick-response" class="close red icon"></i>
						</div>

					</div>

				<?php }

			} else { ?>

				<div class="item" id="no-quick-responses"><?php _e( 'No quick responses', 'wpjobster' ); ?></div>

			<?php } ?>

		</div>

	</div>

</div>