<?php
/**
 * @var $icon
 * @var $interlocutor_id
 * @var $interlocutor_data
 * @var $attach_class
 */
?>

<!-- Scroll down arrow -->
<div class="scroll-down-wrapper js-scroll-down">
	<i class="<?php echo $icon; ?> icon mr0"></i>
</div>

<div class="thread-input">

	<div class="thread-input-padding">

		<!-- Image attachments -->
		<div class="images-attachments-wrapper">

			<?php wpj_display_image_upload_form( $interlocutor_id, 'message', 'messages-image-uploader', 'message_images' ); ?>

		</div>

		<!-- File attachments -->
		<?php if ( wpj_get_option( 'wpjobster_message_attachments_enable' ) != 'no' ) { ?>

			<div class="files-attachments-wrapper">

				<?php wpj_display_file_upload_form( $secure = 1, "file_upload_pm_attachments", "hidden_files_pm_attachments", "private_messages", true ); ?>

			</div>

		<?php } ?>

		<!-- Send message form -->
		<?php if ( is_object( $interlocutor_data ) && isset( $interlocutor_data->user_login ) ) { ?>

			<div class="pr responsive-pm send-my-pm<?php if ( wpj_get_option( 'wpjobster_pm_emoji_enable' ) != 'no' ) { echo ' emoji-enabled'; } ?>">

				<!-- Media attachments buttons -->
				<div class="wrapper-pm-attachments <?php echo $attach_class; ?>">

					<?php // File
					if ( wpj_get_option( 'wpjobster_message_attachments_enable' ) != 'no' ) { ?>

						<div class="pm-file-attachments-button js-pm-file-attach-btn">
							<i class="attach icon"></i>
						</div>

					<?php }

					// Image
					if ( wpj_get_option( 'wpjobster_message_image_attachments_enable' ) != 'no' ) { ?>

						<div class="pm-image-attachments-button js-pm-img-attach-btn">
							<i class="images outline icon"></i>
						</div>

					<?php } ?>

					<!-- Right buttons -->
					<div class="textarea-buttons-wrapper">

						<!-- Settings button -->
						<div class="input-pm-settings mobile-hidden">
							<div class="ui floating bottom right pointing dropdown">
								<i class="cog icon"></i>
								<div class="menu">

									<!-- menu won't be initialized without an item -->
									<div class="item right">
										<i class="close icon" style="margin: 0;"></i>
									</div>

									<div class="header">
										<?php _e( 'Settings', 'wpjobster' ); ?>
									</div>

									<div class="divider"></div>

									<!-- Enter key toggle -->
									<div class="text">
										<div class="ui toggle checkbox mobile-hidden send-message-enter-key">
											<input type="checkbox" id="pm-enter-key"<?php if ( get_user_meta( get_current_user_id(), 'pm_enter_key_enabled', true ) == 1 ) { echo ' checked'; } ?> />
											<label for="pm-enter-key"><?php _e( 'Send message with Enter key', 'wpjobster' ); ?></label>
										</div>
									</div>

									<div class="divider"></div>

									<div class="text">
										<?php _e( 'You can always use <strong>Shift+Enter</strong> <br> to type multi-line messages.', 'wpjobster' ); ?>
									</div>
								</div>
							</div>
						</div>

						<!-- Quick response button -->
						<div class="input-pm-quick-response">

							<?php wpj_display_quick_response( $interlocutor_data->ID, 'pm' ); ?>

						</div>

					</div>

				</div>

				<!-- Textarea -->
				<div class="wrapper-pm-to-user">
					<div class="form-container-pm" data-no-translation>
						<form method="post" class="ui form">
							<input type="hidden" id="pm_interlocutor_id" value="<?php echo $interlocutor_id; ?>" />
							<input type="hidden" id="pm_request_id" value="<?php echo WPJ_Form::get( 'request_id', '' ); ?>" />
							<input type="hidden" id="pm_job_id" value="<?php echo WPJ_Form::get( 'job_id', '' ); ?>" />

							<textarea class="cmi-listen message-field" id="message-pm-user" name="message" rows="1" cols="50"><?php echo WPJ_Form::post( 'message', '' ); ?></textarea>
						</form>
					</div>
				</div>

				<!-- Send button -->
				<div class="wrapper-pm-submit">
					<button class="ui icon button flip-on-rtl submit-private-message" data-interlocutor-id="<?php echo $interlocutor_id; ?>" type="submit" name="send">
						<i class="icons">
							<i class="play icon"></i>
							<i class="white minus icon"></i>
						</i>
					</button>
				</div>

			</div>

		<?php } // endif user is_object ?>

	</div>
</div>