<?php
/**
 * @var $sms_gateway_op
 * @var $notifications_array
 * @var $user_id
 */

if ( $sms_gateway_op && $sms_gateway_op != '-' ) { ?>

	<div class="wpj-bordered-container email-sms-settings-column">

		<h4><?php _e( 'SMS', 'wpjobster' ); ?></h4>

		<ul class="notifications sms_notification reset">

			<li id="all-sms">

				<div class="ui checkbox">

					<input id="all-sms-notify" type="checkbox" value="mark_all_sms_notify" />

					<label class="check-all"><?php _e( 'Check all', 'wpjobster' ); ?></label>

				</div>

			</li>

			<?php if ( $notifications_array ) {

				foreach ( $notifications_array as $sms_category ) {

					if ( isset( $sms_category["items"] ) && $sms_category["items"] ) {

						foreach ( $sms_category["items"] as $reason => $pair ) {

							if ( wpj_get_option( 'uz_sms_' . $reason . '_enable' ) != 'no' ) { $list_has_items = true; ?>

								<li>

									<div class="ui checkbox">

										<input type="checkbox" class="sms_notifications" name="sms_notifications[]" <?php echo ( get_user_meta( $user_id, 'uz_sms_' . $reason . '_enable', true ) != "no" ? " checked " : '' ); ?> value="uz_sms_<?php echo $reason; ?>_enable" />

										<label><?php echo $pair["title"]; ?></label>

									</div>

								</li>

							<?php }

						}

					}

				}

			} else echo '<style>.sms-notifications-list-row-wrapper{display:none;}</style>'; // for page builder

			if ( empty( $list_has_items ) ) echo '<style>.sms-notifications-list-row-wrapper{display:none;}</style>'; // for page builder ?>

		</ul>

	</div>

<?php } else echo '<style>.sms-notifications-list-row-wrapper{display:none;}</style>'; // for page builder