<?php
/**
 * @var $order
 */
?>

<form id="job-order-bank-payment-proof" method="post" enctype="multipart/form-data" class="ui form">

	<div id="job-payment-proof-attachments" class="mb20">
		<?php // DISPLAY ATTACHMENTS
		if ( wpj_post_has_attachments ( $attachments ) ) {
			wpj_display_attachments_list(
				$attachments,
				$order->id,
				'bank_transfer_job_proof_attachments_' . $order->id,
				true,
				__( 'Documents', 'wpjobster' ),
				true,
				true
			);
		}
		?>
	</div>

	<?php // DISPLAY UPLOAD FORM
	wpj_display_file_upload_form(
		$secure = 1,
		'file_upload_bank_transfer_job_proof_attachments_' . $order->id,
		'hidden_files_bank_transfer_job_proof_attachments_' . $order->id,
		'bank_transfer_job_proof_attachments_' . $order->id,
		false,
		__( 'Attach proof of payment', 'wpjobster' )
	);
	?>

	<input type="hidden" name="action" value="save_bank_job_proof_of_payment_action" />
	<input type="hidden" name="order_id" value="<?php echo $order->id; ?>" />

	<button class="text-button text-button-medium save-job-payment-proof mt10 div-disabled">

		<?php _e( 'Save', 'wpjobster' ); ?>

	</button>

</form>