<?php
/**
 * @var $order
 * @var $wrapper_class
 * @var $buttons_wrapper_class
 * @var $button_accept_class
 * @var $button_deny_class
 * @var $button_abort_class
 * @var $buttons_only
 * @var $button1_order
 * @var $button2_order
 * @var $arbitration
 * @var $buyer_level
 * @var $seller_level
 * @var $can_be_completed
 * @var $modification_count
 */

if ( current_user_can( 'manage_options' ) || get_current_user_id() == $order->uid || get_current_user_id() == wpj_get_seller_id( $order ) ) { ?>

	<div class="<?php echo $wrapper_class; ?> js-order-action-buttons">

		<!-- SELLER BUTTONS -->
		<?php if ( get_current_user_id() == wpj_get_seller_id( $order ) ) {

			if (
				wpj_order_can_be_closed( $order, 'request' ) == 1
				&& $order->accept_cancellation_request != -1
				&& $order->request_cancellation_from_buyer == 1
			) { ?>

				<div class="<?php echo $buttons_wrapper_class; ?>">

					<!-- ACCEPT CANCELLATION BTN -->
					<a style="order: <?php echo $button1_order; ?>" class="<?php echo $button_accept_class; ?> js-accept-cancellation-request" onclick="clickAndDisable(this);">
						<?php _e( 'Accept Cancellation', 'wpjobster' ); ?>
					</a>

					<!-- DENY CANCELLATION BTN -->
					<a style="order: <?php echo $button2_order; ?>" class="<?php echo $button_deny_class; ?> js-deny-cancellation-request" onclick="clickAndDisable(this);">
						<?php _e( 'Deny Cancellation', 'wpjobster' ); ?>
					</a>

				</div>

			<?php } elseif ( $order->closed != 1 && $order->request_cancellation_from_seller == 1 ) { ?>

				<!-- ABORT CANCELLATION BTN -->
				<a class="<?php echo $button_abort_class; ?> js-abort-cancellation-request" onclick="clickAndDisable(this);">
					<?php _e( "Abort Cancellation", "wpjobster" ); ?>
				</a>

			<?php } elseif (
				wpj_is_order_delivered( $order ) == 0
				&& $order->closed != 1
				&& $order->request_cancellation_from_buyer != 1
				&& $order->request_cancellation_from_seller != 1
				&& ! wpj_order_has_arbitration( $order->id )
				&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
			) {

				do_action( 'wpj_before_mark_delivered_button', $order->id );

				if ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' && $order->payment_status == 'completed' ) { ?>

					<!-- Show info message -->
					<?php if ( ! $buttons_only ) { ?>

						<div>
							<span class="order-info-message waiting-seller-deliver seller-page">

								<?php if ( $order->seller_confirmation == '0' ) {

									$message = __( 'You have up to 24h to confirm and accept this order, otherwise the order will be automatically cancelled by the system, buyer will be refunded, and you will receive a negative feedback (incomplete order).', 'wpjobster' );

								} elseif ( $order->seller_confirmation == '1' ) {

									$message = __( 'Order has been confirmed by the seller, and delivery timer has been activated.', 'wpjobster' );

								} else {

									add_filter( 'wpj_mark_delivered_btn_filter', '__return_false' );

									$message = __( 'Order has been rejected by the seller and/or the seller did not confirm the order in the designated 24 hours window. This order has been cancelled, and the buyer has been refunded.', 'wpjobster' );

								}

								echo $message; ?>

							</span>
						</div>

					<?php }

					if ( $order->seller_confirmation == '0' ) { ?>

						<!-- Hide mark as delivered button -->
						<?php add_filter( 'wpj_mark_delivered_btn_filter', '__return_false' ); ?>

						<!-- Show seller buttons -->
						<div class="<?php echo $buttons_wrapper_class; ?>">
							<a style="order: <?php echo $button1_order; ?>" class="<?php echo $button_accept_class; ?> js-accept-order" onclick="clickAndDisable( this );"><?php _e( 'Accept', 'wpjobster' ); ?></a>
							<a style="order: <?php echo $button2_order; ?>" class="<?php echo $button_deny_class; ?> js-deny-order" onclick="clickAndDisable( this );"><?php _e( 'Deny','wpjobster' ); ?></a>
						</div>

					<?php }

				}

				if ( apply_filters( 'wpj_mark_delivered_btn_filter', true ) && $order->payment_status == 'completed' ) { ?>

					<!-- MARK AS DELIVERED BTN -->
					<a class="<?php echo $button_accept_class; ?> js-mark-order-delivered" onclick="clickAndDisable(this);">
						<?php _e( "Mark as Delivered", "wpjobster" ); ?>
					</a>

				<?php }

			} elseif (
				! $buttons_only
				&& wpj_is_order_completed( $order ) != 1
				&& $order->closed != 1
				&& $order->request_cancellation_from_buyer != 1
				&& $order->request_cancellation_from_seller != 1
				&& ! wpj_order_has_arbitration( $order->id )
				&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
			) {

				if ( wpj_is_order_completed( $order ) == -1 ) { ?>

					<!-- DISPUTE INITIATED TXT -->
					<span class="order-info-message">
						<?php _e( 'A dispute has been initiated for this order', 'wpjobster' ); ?>
					</span>

				<?php } else { ?>

					<!-- WAITING FOR BUYER TXT -->
					<span class="order-info-message">
						<?php _e( 'Waiting for the buyer to confirm', 'wpjobster' ); ?>
					</span>

				<?php }

			} elseif (
				is_object( $arbitration )
				&& $arbitration->buyer_arbitration == 0
				&& $arbitration->seller_arbitration == 0
				&& $arbitration->request_from_seller == 1
				&& $order->closed != 1
			) { ?>

				<!-- ABORT ARBITRATION BTN -->
				<a class="<?php echo $button_abort_class; ?> js-abort-arbitration-request" onclick="clickAndDisable(this);">
					<?php _e( "Abort Arbitration", "wpjobster" ); ?>
				</a>

			<?php } elseif ( wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' ) && $order->closed != 1 ) { ?>

				<!-- ABORT EXTENDED DELIVERY BTN -->
				<a class="<?php echo $button_abort_class; ?> js-abort-extended-delivery-time-request" onclick="clickAndDisable( this );">
					<?php _e( "Abort Extended Delivery Time", "wpjobster" ); ?>
				</a>

			<?php }

		} ?>

		<!-- BUYER BUTTONS -->
		<?php if ( get_current_user_id() != wpj_get_seller_id( $order ) ) {

			if (
				wpj_order_can_be_closed( $order, 'request' ) == 1
				&& $order->accept_cancellation_request != -1
				&& $order->request_cancellation_from_seller == 1
			) { ?>

				<div class="<?php echo $buttons_wrapper_class; ?>">

					<!-- ACCEPT CANCELLATION BTN -->
					<a style="order: <?php echo $button1_order; ?>" class="<?php echo $button_accept_class; ?> js-accept-cancellation-request" onclick="clickAndDisable(this);">
						<?php _e( 'Accept Cancellation', 'wpjobster' ); ?>
					</a>

					<!-- DENY CANCELLATION BTN -->
					<a style="order: <?php echo $button2_order; ?>" class="<?php echo $button_deny_class; ?> js-deny-cancellation-request" onclick="clickAndDisable(this);">
						<?php _e( 'Deny Cancellation', 'wpjobster' ); ?></a>

				</div>

			<?php } elseif ( $order->closed != 1 && $order->request_cancellation_from_buyer == 1 ) { ?>

				<!-- ABORT CANCELLATION BTN -->
				<a class="<?php echo $button_abort_class; ?> js-abort-cancellation-request" onclick="clickAndDisable(this);">
					<?php _e( "Abort Cancellation", "wpjobster" ); ?>
				</a>

			<?php } elseif (
				wpj_is_order_completed( $order ) == 0
				&& $order->done_seller == 1
				&& $order->closed != 1
				&& ! wpj_order_has_arbitration( $order->id )
				&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
			) {

				if (
					wpj_get_option( 'wpjobster_tips_enabled' ) != 'no'
					&& $buyer_level != 'no'
					&& $seller_level != 'no'
				) { ?>

					<!-- ADD TIP BTN -->
					<a class="open-modal-tips-chatbox text-button text-button-secondary" onclick="clickAndDisable(this);">
						<i class="dollar sign icon"></i>
						<?php _e( "Tip Seller", "wpjobster" ); ?>
					</a>

				<?php }

				if ( $can_be_completed ) { ?>

					<!-- MARK AS COMPLETED BTN -->
					<a class="<?php echo $button_accept_class; ?> js-mark-order-completed" onclick="clickAndDisable(this);">
						<?php _e( "Mark Completed", "wpjobster" ); ?>
					</a>

				<?php }

				if ( $modification_count < wpj_get_option( 'wpjobster_number_of_modifications' ) ) { ?>

					<!-- REQUEST MODIFICATION BTN -->
					<a href="#" onclick="event.preventDefault();" class="text-button text-button-warning open-modal-request-modifications" onclick="clickAndDisable(this);">
						<?php _e( 'Request Modification', 'wpjobster' ); ?>
					</a>

				<?php }

			} elseif (
				! $buttons_only
				&& wpj_is_order_delivered( $order ) != 1
				&& $order->closed != 1
				&& $order->request_cancellation_from_seller == 0
				&& ! wpj_order_has_arbitration( $order->id )
				&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
			) {

				if ( wpj_is_order_delivered( $order ) == -1 ) { ?>

					<!-- DISPUTE INITIATED TXT -->
					<span class="order-info-message">
						<?php _e( 'A dispute has been initiated for this order', 'wpjobster' ); ?>
					</span>

				<?php } elseif ( $order->payment_status == 'completed' ) { ?>

					<!-- WAITING FOR SELLER TXT -->
					<div>
						<span class="order-info-message waiting-seller-deliver">

							<?php if ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' ) {

								if ( $order->seller_confirmation == '0' ) {
									$message = __( 'This order is pending until seller confirms it. Seller is given up to 24h to confirm and accept this order, otherwise the order will be automatically cancelled by the system, and you will be refunded.', 'wpjobster' );

								} elseif ( $order->seller_confirmation == '1' ) {
									$message = __( 'Order has been confirmed by the seller, and delivery timer has been activated.', 'wpjobster' );

								} else {
									$message = __( 'Order has been rejected by the seller and/or the seller did not confirm the order in the designated 24 hours window. This order has been cancelled, and the buyer has been refunded.', 'wpjobster' );

								}

							} else {

								$message = __( 'Waiting for the seller to deliver', 'wpjobster' );

							}

							echo apply_filters( 'wpj_seller_deliver_msg_filter', $message, $order->id ); ?>

						</span>
					</div>

				<?php }

			} elseif (
				is_object( $arbitration )
				&& $arbitration->buyer_arbitration == 0
				&& $arbitration->seller_arbitration == 0
				&& $arbitration->request_from_buyer == 1
			) { ?>

				<!-- ABORT ARBITRATION BTN -->
				<a class="<?php echo $button_abort_class; ?> js-abort-arbitration-request" onclick="clickAndDisable(this);">
					<?php _e( "Abort Arbitration", "wpjobster" ); ?>
				</a>

			<?php } elseif ( wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' ) ) { ?>

				<div class="<?php echo $buttons_wrapper_class; ?>">

					<!-- ACCEPT EXTENDED DELIVERY BTN -->
					<a style="order: <?php echo $button1_order; ?>" class="<?php echo $button_accept_class; ?> js-accept-extended-delivery-time-request" onclick="clickAndDisable( this );">
						<?php _e( 'Accept Extended Delivery Time', 'wpjobster' ); ?>
					</a>

					<!-- DENY EXTENDED DELIVERY BTN -->
					<a style="order: <?php echo $button2_order; ?>" class="<?php echo $button_deny_class; ?> js-deny-extended-delivery-time-request" onclick="clickAndDisable( this );">
						<?php _e( 'Deny Extended Delivery Time', 'wpjobster' ); ?>
					</a>

				</div>

			<?php }

			// CANCEL EXPIRED ORDER
			if (
				$order->payment_status == 'completed'
				&& $order->closed != 1
				&& wpj_is_order_time_up( $order ) == 1
				&& get_post_meta( $order->pid, 'instant', true ) != 1
				&& $order->request_cancellation_from_buyer != 1
				&& $order->request_cancellation_from_seller != 1
				&& ! wpj_order_has_arbitration( $order->id )
				&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
				&& (
					( wpj_get_option( 'wpjobster_stop_transaction_clock' ) == 'delivered' && wpj_is_order_delivered( $order ) != 1 )
					|| ( wpj_get_option( 'wpjobster_stop_transaction_clock' ) == 'completed' && wpj_is_order_completed( $order ) != 1 )
				)
			) {

				if ( apply_filters( 'wpj_cancel_order_btn_filter', true, $order->id ) ) { ?>

					<a class="<?php echo $button_abort_class; ?> js-cancel-expired-order" onclick="clickAndDisable( this );">

						<?php echo apply_filters( 'wpj_cancel_order_string_filter', __( "Cancel Order", "wpjobster" ) ); ?>

					</a>

				<?php }

			}

			// CANCEL PENDING ORDER
			if ( $order->payment_status == 'pending' && get_post_status( $order->pid ) == 'publish' ) { ?>

				<a class="<?php echo $button_deny_class; ?>" onclick='take_to_gateway_job_purchase_process( "cancel", "<?php echo $order->id; ?>", "<?php echo $order->payment_gateway; ?>" )'>

					<?php _e( 'Cancel', 'wpjobster' ); ?>

				</a>

				<?php if ( $order->payment_gateway != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $order->payment_gateway ) ) { ?>

					<a class="<?php echo $button_accept_class; ?>" onclick='take_to_gateway_job_purchase_process( "process", "<?php echo $order->id; ?>", "<?php echo $order->payment_gateway; ?>" )'>

						<?php _e( 'Process', 'wpjobster' ); ?>

					</a>

				<?php } ?>

			<?php } elseif ( $order->payment_status == 'pending' && ! $buttons_only ) { ?>

				<span class="order-info-message"><?php _e( 'This job is not available anymore.', 'wpjobster' ); ?></span>

			<?php }

		}

		if ( $wrapper_class == 'order-header-action-buttons-wrapper' ) do_action( 'wpj_after_order_header_action_buttons', $order );
		if ( $wrapper_class == 'order-footer-action-buttons-wrapper' ) do_action( 'wpj_after_order_footer_action_buttons', $order ); ?>

	</div>

<?php } ?>