<?php
/**
 * @var $order
 * @var $rating_row
 * @var $user_rated
 * @var $textarea_wrapper_classes
 * @var $user_sample
 * @var $rating_class
 * @var $user_skills
 */
?>

<div id="order-feedback-form-wrapper">

	<?php if ( ! in_array( $order->payment_status, array( 'pending', 'failed', 'processing', 'cancelled' ) ) ) {

		if ( $rating_row ) { ?>

			<div class="order-feedback-form-wrapper full-width-container">

				<div class="order-feedback-form-container">

					<div class="order-feedback-form js-review-form" id="post-<?php echo $rating_row->id; ?>">

						<p class="review-form-title">

							<?php echo sprintf( __( 'Please rate your experience with <strong>%s</strong>.', 'wpjobster' ), $user_rated ); ?>

						</p>

						<div class="stars-rating">
							<form class="rating" id="rating-<?php echo $rating_row->id; ?>">
								<input type="radio" name="stars" id="5_stars" value="5" >
								<label class="stars" for="5_stars"></label>

								<input type="radio" name="stars" id="4_stars" value="4" >
								<label class="stars" for="4_stars"></label>

								<input type="radio" name="stars" id="3_stars" value="3" >
								<label class="stars" for="3_stars"></label>

								<input type="radio" name="stars" id="2_stars" value="2" >
								<label class="stars" for="2_stars"></label>

								<input type="radio" name="stars" id="1_stars" value="1" required>
								<label class="stars" for="1_stars"></label>
							</form>
						</div>

						<div class="wpj-review-work-sample-wrapper ui stackable grid<?php if ( wpj_function_has_content( 'wpj_display_work_sample_carousel', array( $order->id, $user_sample ) ) ) echo ' work-sample-container'; ?>">

							<div class="<?php echo $textarea_wrapper_classes; ?> column">

								<textarea placeholder="<?php _e( 'Help the community by sharing your order experience...', 'wpjobster' ); ?>" class="<?php echo $rating_class; ?>" id="reason-<?php echo $rating_row->id; ?>" rows="2"></textarea>

							</div>

							<?php if ( wpj_function_has_content( 'wpj_display_work_sample_carousel', array( $order->id, $user_sample ) ) ) { ?>

								<div class="three wide column"><?php wpj_display_work_sample_carousel( $order->id, $user_sample ); ?></div>

							<?php } ?>

						</div>

						<?php if ( $user_skills && $user_sample == 'buyer' ) { ?>

							<div class="cb-skills-wrapper center mb32">

								<?php _e( 'Endorse this user\'s skills:', 'wpjobster' );

								foreach ( $user_skills as $user_skill ) { ?>

									<div class="ui small basic label" data-slug="<?php echo $user_skill['slug']; ?>">

										<span class="skill-name">
											<?php echo $user_skill['name']; ?>
										</span>

										<span class="js-endorse-skill cursor-pointer">
											<i class="plus circle icon"></i>
										</span>

									</div>

								<?php } ?>

							</div>


						<?php } ?>

						<div class="cf center">
							<a
								data-buyer-id="<?php echo $order->uid; ?>"
								data-order-id="<?php echo $order->id; ?>"
								data-post-id="<?php echo $order->pid; ?>"
								data-user="<?php echo $user_sample; ?>"
								rel="<?php echo $rating_row->id; ?>"
								class="text-button text-button-light submit-user-rating cursor-pointer"
							>
								<?php _e( 'Submit Rating', 'wpjobster' ); ?>
							</a>
						</div>
					</div>

				</div>

			</div>

		<?php }

	} ?>

</div>