<?php
/**
 * @var $instant_delivery_attachments
 * @var $order
 */

if ( get_post_meta( $order->pid, 'instant', true ) == 1 && ( $order->done_seller == 1 || get_current_user_id() == wpj_get_seller_id( $order ) ) ) {

	if ( wpj_post_has_attachments( $instant_delivery_attachments ) ) {

		wpj_display_attachments_list( $instant_delivery_attachments, $order->pid, 'job_any_attachments', '', '', true, false );

	} else {

		if ( isset( $instant_attachments ) ) {
			foreach ( $instant_attachments as $attach ) {
				if ( $attach->post_mime_type == 'application/zip' ) { ?>

					<div class="attachments-wrapper">

						<a class="attachment-item-link" href="<?php echo wp_get_attachment_url( $attach->ID ); ?>" download>
							<?php echo $attach->post_title; ?>
						</a>

						&nbsp;

						<span class="attachment-item-filesize"><?php echo size_format( filesize( get_attached_file( $attach->ID ) ) ); ?></span>

						<br>

					</div>

				<?php }
			}
		}

	}

}