<?php
/**
 * @var $order
 */
?>

<div class="order-price">

	<?php if ( apply_filters( 'wpj_order_price_filter', true, $order ) ) {

		if ( $order->job_price ) {

			if ( $order->job_amount != 1 ) { ?>

				<span class="amount-nr">

					<?php echo $order->job_amount; ?>

					<span class="x-sign"> x </span>

				</span>
			<?php }

			echo wpj_show_price_classic( $order->job_price, 1 );

			if ( $order->job_type && $order->job_type != 'fixed' ) {
				echo '&nbsp;<span class="order-price-type">' . wpj_translate_string( $order->job_type ) . '</span>';
			}

		} else {

			if ( $order->job_amount != 1 ) { ?>

				<span class="amount-nr">

					<?php echo $order->job_amount; ?>

					<span class="x-sign"> x </span>

				</span>

			<?php }

			if ( wpj_bool_option( 'wpjobster_replace_zero_with_free' ) ) {
				_e( 'Free', 'wpjobster' );

			} else {
				echo wpj_show_price( $order->job_price );

			}

		}

	}?>

</div>