<?php
/**
 * @var $order
 * @var $completed
 * @var $buyer_arbitration
 * @var $seller_id
 * @var $buyer_id
 * @var $uid
 * @var $qr_uid
 */
?>

<div id="order-message-form-wrapper">

	<?php if ( ! in_array( $order->payment_status, array( 'pending', 'failed', 'processing', 'cancelled' ) ) ) { ?>

		<?php if ( $completed != 1 && $order->closed != 1 && $order->force_cancellation != 2 && ! $buyer_arbitration ) { ?>

			<div class="full-width-container messages-form-wrapper">

				<div class="messages-form-container main-content">

					<div class="order-message-form-content<?php if ( wpj_get_option( 'wpjobster_transaction_emoji_enable' ) != 'no' ) { echo ' emoji-enabled'; } ?>">

						<div class="order-messages-header">

							<div class="order-message-form-title"><?php _e( 'Send a message', 'wpjobster' ); ?></div>

							<div class="order-message-form-buttons">

								<div class="tips-extra-button-wrapper">

									<?php // CUSTOM EXTRA
									if ( $uid == $seller_id && wpj_get_option( 'wpjobster_enable_custom_extras' ) == 'yes' ) {
										wpj_display_custom_offer_button( array(
											'unique_id'       => 'order_send_' . $order->pid,
											'id'              => $order->pid,
											'title'           => apply_filters( 'wpj_add_custom_extra_string_filter', __( 'Add Custom Extra', 'wpjobster' ) ),
											'offer_type'      => 'send',
											'current_user_id' => $seller_id,
											'post_author_id'  => $buyer_id,
											'page'            => 'order',
											'oid'             => $order->id,
											'extra'           => true
										) );
									}

									// TIPS
									if (
										$uid != $seller_id
										&& wpj_get_option( 'wpjobster_tips_enabled' ) != 'no'
										&& wpj_get_user_feature_value( 'tips', 'tips', 'no', $uid ) != 'no'
										&& wpj_get_user_feature_value( 'tips', 'tips', 'no', $seller_id ) != 'no'
									) { ?>

										<a class="text-button text-button-secondary open-modal-tips-chatbox"><?php _e( "Tip Seller", "wpjobster" ); ?></a>

									<?php } ?>

								</div>

								<div class="resolution-center-button-wrapper">

									<?php // RESOLUTION CENTER
									if (
										$uid == $buyer_id
										&& wpj_is_order_time_up( $order ) == 1
										&& get_post_meta( $order->pid, 'instant', true ) != 1
										&& $order->request_cancellation_from_buyer != 1
										&& $order->request_cancellation_from_seller != 1
										&& ! wpj_order_has_arbitration( $order->id )
										&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' ) ) {

									} else {
										if ( wpj_order_can_be_closed( $order, 'request' ) == 1 ) {
											if (
												! wpj_order_has_arbitration( $order->id )
												&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
												&& $order->request_cancellation_from_seller != 1
												&& $order->request_cancellation_from_buyer != 1
											) { ?>

												<a class="text-button text-button-gray2 open-modal-resolution-center"><?php _e( "Resolution Center", "wpjobster" ); ?></a>

											<?php }
										}
									} ?>

								</div>

							</div>

						</div>

						<form id="order-message-form" method="post" enctype="multipart/form-data" class="ui form">

							<div class="ui middle aligned grid">

								<div class="sixteen wide column">

									<input type="hidden" name="action" value="send_transaction_message_action" />
									<input type="hidden" name="order_id" value="<?php echo $order->id; ?>" />

									<?php
									do_action( 'wpj_before_order_message_form_input', $order, $buyer_id, $seller_id );
									
									wpj_display_quick_response( $qr_uid, 'order' );
									?>

									<textarea class="order-message-form-textarea charlimit-message textarea-resize-vertical cmi-listen message-field " name="message"><?php echo WPJ_Form::post( 'message' ); ?></textarea>

									<span class="charscounter"><?php _e( 'characters left', 'wpjobster' ); ?></span>

									<div class="ui slider checkbox right mobile-hidden send-message-enter-key mt5">

										<input type="checkbox" id="pm-enter-key"<?php if ( get_user_meta( $uid, 'pm_enter_key_enabled', true ) == 1 ) { echo ' checked'; } ?> />
										<label for="pm-enter-key"><?php _e( 'Send message with Enter key', 'wpjobster' ); ?></label>

									</div>

								</div>

							</div>

							<div class="ui middle aligned grid">

								<div class="twelve wide column">

									<?php if ( wpj_get_option( 'wpjobster_message_attachments_enable' ) != 'no' ) {

										wpj_display_file_upload_form( 1, "file_upload_chat_box_attachments", "hidden_files_chat_box_attachments", "chat_box" );

									} ?>

								</div>

								<div class="four wide column">
									<button class="text-button text-button-medium send-message right mr0">

										<?php _e( 'Send', 'wpjobster' ); ?>

									</button>
								</div>

							</div>
						</form>

					</div>

				</div>

			</div>

		<?php } ?>

	<?php } ?>

</div>