<?php
/**
 * @var $order
 * @var $chatbox_row
 * @var $rating_oid
 * @var $rating_oid_row
 * @var $custom_extras
 * @var $buyer_arbitration
 */
?>

<div id="order-notification-messages-wrapper" class="order-notification-messages-wrapper" data-order-id="<?php echo $order->id; ?>">

	<?php if ( ! in_array( $order->payment_status, array( 'failed', 'processing', 'cancelled' ) ) ) {

		if ( $chatbox_row ) {

			foreach ( $chatbox_row as $row ) {

				$chatbox_data = wpj_get_order_notifications_data( $row );

				if ( $chatbox_data['message'] ) { ?>

					<div class="order-box-wrapper <?php echo apply_filters( 'wpj_order_section_wrapper_class_filter', '', $order, $row ); ?>">

						<div class="order-box-header <?php echo $chatbox_data['bgcolor']; ?>">

							<div class="icon">
                                <img class="<?php if ( $row->uid > 0 ) echo 'round-avatar'; ?>" src="<?php echo $chatbox_data['icon']; ?>" alt="" />
                            </div>

							<div class="content">

								<h3>

									<?php
									if ( $row->uid == -1 ) _e( 'Delivered', 'wpjobster' );
									elseif ( $row->uid == -2 ) _e( 'Completed', 'wpjobster' );
									elseif ( $row->uid == -8 || $row->uid == -9 ) _e( 'Cancellation Requested', 'wpjobster' );
									elseif ( $row->uid == -10 || $row->uid == -12 ) _e( 'Cancellation Accepted', 'wpjobster' );
									elseif ( $row->uid == -11 || $row->uid == -13 ) _e( 'Cancellation Declined', 'wpjobster' );
									elseif ( $row->uid == -16 || $row->uid == -17 ) _e( 'Cancellation Aborted', 'wpjobster' );
									elseif ( in_array( $row->uid, array( -14, -21, -22 ) ) ) _e( 'Cancellation', 'wpjobster' );
									elseif ( $row->uid == -35 ) _e( 'Delivery Time Expired', 'wpjobster' );
									elseif ( $row->uid == -15 ) _e( 'Modifications Requested', 'wpjobster' );
									elseif ( $row->uid == -18 ) _e( 'Buyer Feedback', 'wpjobster' );
									elseif ( $row->uid == -19 ) _e( 'Seller Feedback', 'wpjobster' );
									elseif ( $row->uid == -31 ) echo apply_filters( 'wpj_custom_extra_string_filter', __( 'Custom Extra', 'wpjobster' ) );
									elseif ( $row->uid == -36 ) _e( 'Tips', 'wpjobster' );
									elseif ( $row->uid == -39 || $row->uid == -40 ) _e( 'Arbitration Requested', 'wpjobster' );
									elseif ( in_array( $row->uid, array( -41, -42, -43, -44 ) ) ) _e( 'Arbitration', 'wpjobster' );
									elseif ( $row->uid == -45 || $row->uid == -46 ) _e( 'Arbitration Aborted', 'wpjobster' );
									elseif ( $row->uid == -49 ) _e( 'Extended Delivery Requested', 'wpjobster' );
									elseif ( $row->uid == -50 ) _e( 'Extended Delivery Aborted', 'wpjobster' );
									elseif ( $row->uid == -51 ) _e( 'Extended Delivery Accepted', 'wpjobster' );
									elseif ( $row->uid == -52 ) _e( 'Extended Delivery Declined', 'wpjobster' );
									elseif ( $row->uid > 0 ) _e( 'Message', 'wpjobster' );
									else echo sprintf( __( 'Order: <strong>#%s</strong>', 'wpjobster' ), wpj_camouflage_oid( $order->id, $order->date_made ) );
									?>

								</h3>

								<!-- ORDER DATE -->
								<div class="order-date">

									<?php if ( isset( $row->datemade ) )
										echo wpj_date( wpj_get_option( 'date_format' ) . ' ' . wpj_get_option( 'time_format' ), $row->datemade );

									else
										wpj_display_order_date_made( $order ); ?>

								</div>

							</div>

							<?php do_action( 'wpj_after_order_box_header_content', $order, $row ); ?>

						</div>

						<div class="order-box-content">

							<div>

								<?php // DISPLAY ADMIN (SUPPORT) LABEL
								if ( $row->uid > 0 ) { ?>

									<div>
										<a href="<?php echo wpj_get_user_profile_link( $row->uid ); ?>">
											<strong>

												<?php echo wpj_get_user_display_type( $row->uid );

												if ( is_super_admin( $row->uid ) ) { ?>

													&nbsp;<span class="red">(<?php _e( 'support', 'wpjobster' ); ?>)</span>

												<?php } ?>

											</strong>
										</a>
									</div>

								<?php }

								// DISPLAY WORK SAMPLE
								if ( $row->uid == -18 ) { ?>

									<div class="df wpj-review-work-sample-wrapper">
										<div><?php wpj_display_rating_stars( $rating_oid_row->grade ); ?>

								<?php }

											// DISPLAY THE MAIN CONTENT OF ROW
											echo wpj_make_links_clickable( apply_filters( 'wpj_order_notification_message_filter', $chatbox_data['message'], $row, $order ) );

								if ( $row->uid == -18 ) { ?>

										</div>

										<?php if ( isset( $rating_oid_row->sample ) ) { wpj_display_work_sample_preview_image( $rating_oid_row->sample ); } ?>

									</div>

								<?php }

								// DISPLAY ATTACHMENTS
								if ( wpj_post_has_attachments ( $row->attachment ) ) {
									wpj_display_attachments_list( $row->attachment, '', '', true, __( 'Attachments', 'wpjobster' ), true, false );
								}

								// DISPLAY CUSTOM EXTRA CONTENT
								if ( $row->uid == -31 ) {

									$custom_extra     = $custom_extras[$row->content];
									$custom_extra_arr = wpj_get_custom_extra_order( '*', ['order_id' => $order->id, 'custom_extra_id' => $row->content], 'row' );

									$ce_description = $custom_extra->description;
									$ce_description = wpj_apply_filter_to_string( $ce_description, false, 'transactionpages' );

									$banktransfer_ce    = wpj_get_custom_extra_order( '*', ['order_id' => $order->id, 'custom_extra_id' => $row->content], 'row' );
									$banktransfer_order = false;

									if ( $banktransfer_ce && $banktransfer_ce->payment_gateway_name == 'banktransfer' && $banktransfer_ce->payment_status == 'pending' ) {
										$banktransfer_order = true;
									} ?>

									<div class="meta-columns-wrapper">

										<div class="meta-column">

											<div class="label-class"><?php _e( 'Price:', 'wpjobster' ); ?></div>

											<div class="value-class"><?php echo wpj_show_price_classic( apply_filters( 'wpj_custom_extra_price_filter', $custom_extra->price, $row->content, $order ), 1 ); ?></div>

										</div>

										<div class="meta-column">

											<div class="label-class"><?php _e( 'Delivery:', 'wpjobster' ); ?></div>

											<div class="value-class"><?php echo sprintf( _n( "%s day", "%s days", $custom_extra->delivery, "wpjobster" ), $custom_extra->delivery ); ?></div>

										</div>

										<?php if ( $custom_extra->declined == true ) { ?>

											<div class="meta-column">
												<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
												<div class="value-class red"><?php _e( 'Declined', 'wpjobster' ); ?></div>
											</div>

											<?php } elseif ( $custom_extra->cancelled == true ) { ?>

											<tr>
											<div class="meta-column">
												<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
												<div class="value-class"><?php _e( 'Cancelled', 'wpjobster' ); ?></div>
											</div>

											<?php } elseif ( $custom_extra->paid == true ) {

											if (
												$custom_extra_arr
												&& $custom_extra_arr->payment_gateway_name == 'cod'
												&& $custom_extra_arr->payment_gateway_transaction_id == '-1'
												&& get_current_user_id() != wpj_get_seller_id( $order )
											) {
												$paid_status = __( 'waiting to be marked as paid','wpjobster' );
												$paid_class = '';
											} else {
												$paid_status = apply_filters( 'wpj_custom_extra_paid_status_string_filter', __( 'Paid', 'wpjobster' ), $order, $row );
												$paid_class = 'green';
											} ?>

												<div class="meta-column">
													<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
													<div class="value-class <?php echo $paid_class; ?>"><?php echo $paid_status; ?></div>
												</div>

											<?php } else {

											if ( $banktransfer_order ) { ?>

												<div class="meta-column">
													<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
													<div class="value-class"><?php _e( 'pending', 'wpjobster' ); ?></div>
												</div>

												<?php if ( get_current_user_id() != wpj_get_seller_id( $order ) ) { ?>

													<div class="meta-column">
														<div class="label-class"><?php _e( 'Bank Details:', 'wpjobster' ); ?></div>
														<div class="value-class"><?php wpj_display_bank_details(); ?></div>
													</div>

												<?php }

											} else { ?>

												<div class="meta-column">
													<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
													<div class="value-class"><?php _e( 'waiting to be marked as paid', 'wpjobster' ); ?></div>
												</div>

											<?php }
										} ?>

									</div>

									<div class="meta-columns-wrapper">

										<div class="meta-column">
											<div class="label-class"><?php _e( 'Description:', 'wpjobster' ); ?></div>
											<div class="value-class"><?php echo $ce_description; ?></div>
										</div>

									</div>

									<table class="pm-custom-extra-meta">
										<tbody>

											<?php if ( $custom_extra_arr ) {

												if ( $custom_extra_arr->payment_gateway_name == 'cod' && $custom_extra_arr->payment_gateway_transaction_id == '-1' ) {

													if ( get_current_user_id() == wpj_get_seller_id( $order ) ) { ?>

														<tr>
															<td colspan="2">

																<div class="order-box-wrapper cf ui notpadded segment">
																	<div class="order-box-content">

																		<div class="order-box-left orange">
																			<img width="50" height="50" alt="" src="<?php echo get_template_directory_uri() . '/assets/images/notification/cash.png'; ?>" />
																		</div>

																		<div class="order-box-right">
																			<div>
																				<h3 class="no-margin mb10">
																					<?php _e( "Payment method: Cash on Delivery", "wpjobster" ); ?>
																				</h3>

																				<?php _e( "Since the payment has not been secured by the platform, please make sure you have collected the payment from the buyer, before marking this transaction as delivered.", "wpjobster" ); ?>
																			</div>

																			<div class="ui clearing divider"></div>

																			<a class="ui button positive js-accept-custom-extra" data-custom-extra="<?php echo $row->content; ?>">

																				<?php echo apply_filters( 'wpj_mark_custom_extra_paid_string_filter', __( 'Mark this custom extra as paid', 'wpjobster' ) ); ?>

																			</a>

																		</div>
																	</div>
																</div>

															</td>
														</tr>

													<?php }

												}

											} ?>

										</tbody>
									</table>

									<?php if (
										get_current_user_id() != wpj_get_seller_id( $order )
										&& ! $custom_extra->paid
										&& ! $custom_extra->cancelled
										&& ! $custom_extra->declined
										&& wpj_is_order_completed( $order ) != 1
										&& $order->closed != 1
									) {
										if ( $banktransfer_order ) { ?>

											<!-- CANCEL BANK TRANSFER CUSTOM EXTRA -->
											<div class="custom_extra_chatbox_buttons">

												<a href="<?php bloginfo( 'url' ); ?>/?payment_response=<?php echo $banktransfer_ce->payment_gateway_name; ?>&payment_type=custom_extra&order_id=<?php echo $banktransfer_ce->id; ?>&action=cancel" class="text-button text-button-gray">

													<?php _e( 'Cancel', 'wpjobster' ); ?>

												</a>

											</div>

										<?php } else { ?>

											<div class="custom_extra_chatbox_buttons">

												<!-- ACCEPT CUSTOM EXTRA -->
												<form method="post" name="purchase_custom_extra<?php echo $row->content; ?>" class="dib" action="<?php echo get_permalink( wpj_get_option( 'wpjobster_checkout_page_id' ) ); ?>">

													<button type="submit" class="text-button text-button-confirmation custom-offer-pm <?php echo apply_filters( 'wpj_accept_custom_extra_class_filter', 'btn-accept-custom-extra', $order, $row ); ?>">

														<?php echo apply_filters( 'wpj_accept_custom_extra_string_filter', __( 'Accept custom extra', 'wpjobster' ) ); ?>

													</button>

													<input type="hidden" name="purchaseformvalidation" value="ok" />
													<input type="hidden" name="oid" value="<?php echo $order->id; ?>" />
													<input type="hidden" name="custom_extra" value="<?php echo $row->content; ?>" />

												</form>

												<!-- DECLINE CUSTOM EXTRA -->
												<span>

													<a class="text-button text-button-negative custom-offer-pm <?php echo apply_filters( 'wpj_deny_custom_extra_class_filter', 'js-decline-custom-extra', $order, $row ); ?>" data-custom-extra="<?php echo $row->content; ?>">

														<?php echo apply_filters( 'wpj_decline_custom_extra_string_filter', __( 'Decline custom extra', 'wpjobster' ) ); ?>

													</a>

												</span>

											</div>

										<?php }
									}

									do_action( 'wpj_after_ce_buttons', $order, $row );

									// CANCEL CUSTOM EXTRA
									if (
										get_current_user_id() == wpj_get_seller_id( $order )
										&& ! $custom_extra->paid
										&& ! $custom_extra->cancelled
										&& ! $custom_extra->declined
										&& ! $banktransfer_order
										&& wpj_is_order_completed( $order ) != 1
										&& $order->closed != 1
									) { ?>

										<div class="custom_extra_chatbox_buttons">

											<a class="text-button text-button-negative <?php echo apply_filters( 'wpj_cancel_custom_extra_class_filter', 'js-cancel-custom-extra', $order, $row ); ?>" data-custom-extra="<?php echo $row->content; ?>">

												<?php echo apply_filters( 'wpj_cancel_custom_extra_string_filter', __( 'Cancel custom extra', 'wpjobster' ) ); ?>

											</a>

										</div>

									<?php }

								}

								// DISPLAY TIPS
								if ( $row->uid == -36 ) {

									$tips   = wpj_json_decode( wpj_stripslashes( $order->tips ) );
									$tip    = $tips[$row->content];
									$reason = $tip->reason;

									$banktransfer_tips = wpj_get_tips_order( '*', ['order_id' => $order->id, 'tips_id' => $row->content], 'row' );

									if ( get_current_user_id() != wpj_get_seller_id( $order ) || $tip->paid ) { ?>

										<div class="meta-columns-wrapper">

											<?php if ( $reason ) {
												$reason = wpj_apply_filter_to_string( $reason, false, 'transactionpages' ); ?>

												<div class="meta-column">

													<div class="label-class"><?php _e( 'Reason:', 'wpjobster' ); ?></div>

													<div class="label-value"><?php echo $reason; ?></div>

												</div>

											<?php } ?>

											<div class="meta-column">

												<div class="label-class"><?php _e( 'Price:', 'wpjobster' ); ?></div>

												<div class="label-value"><?php echo wpj_show_price_classic( $tip->amount, 1 ); ?></div>

											</div>

											<?php if ( $tip->paid ) { ?>

												<div class="meta-column">

													<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
													<div class="label-value green"><?php _e( 'Paid', 'wpjobster' ); ?></div>

												</div>

											<?php } elseif ( ! $tip->paid && ! $tip->cancelled ) { ?>

												<div class="meta-column">

													<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
													<div class="label-value yellow"><?php _e( 'pending', 'wpjobster' ); ?></div>

												</div>

												<?php if ( $banktransfer_tips && $banktransfer_tips->payment_gateway_name == 'banktransfer' ) { ?>

													<div class="meta-column">

														<div class="label-class"><?php _e( 'Bank Details:', 'wpjobster' ); ?></div>
														<div class="label-value"><?php wpj_display_bank_details(); ?></div>

													</div>

												<?php }

											}

											if ( $tip->cancelled ) { ?>

												<div class="meta-column">

													<div class="label-class"><?php _e( 'Status:', 'wpjobster' ); ?></div>
													<div class="label-value yellow"><?php _e( 'cancelled', 'wpjobster' ); ?></div>

												</div>

											<?php } ?>

										</div>

									<?php }

									if ( get_current_user_id() != wpj_get_seller_id( $order ) ) {

										if ( ! $tip->paid && ! $tip->cancelled ) {

											if ( $banktransfer_tips && $banktransfer_tips->payment_gateway_name != 'banktransfer' ) { ?>

												<div class="meta-columns-wrapper">

													<div class="meta-column">

														<div class="label-class"><?php _e( 'Pending payment:', 'wpjobster' ); ?></div>
														<div class="label-value yellow"><?php _e( 'If you have already paid for the tip and still see the order as pending, wait a few minutes until we receive the response from the gateway and mark the order as paid.', 'wpjobster' ); ?></div>

													</div>

												</div>

											<?php }

										} ?>

										<div>

											<?php if ( ! $tip->paid && ! $tip->cancelled ) {

												if ( $banktransfer_tips && $banktransfer_tips->payment_gateway_name == 'banktransfer' ) {}
												else { ?>

													<form method="post" name="purchase<?php echo $row->content; ?>" action="<?php echo get_permalink( wpj_get_option( 'wpjobster_checkout_page_id' ) ); ?>" class="dib">

														<button type="submit" class="custom-offer-pm ui text-button text-button-confirmation">

															<?php _e( "Pay", "wpjobster" ); ?>

														</button>

														<input type="hidden" name="purchaseformvalidation" value="ok" />
														<input type="hidden" name="oid" value="<?php echo $order->id; ?>" />
														<input type="hidden" name="tips" value="<?php echo $row->content; ?>" />

													</form>

												<?php }
											}

											if ( ! $tip->paid && ! $tip->cancelled ) { ?>

												<a class="text-button text-button-negative ml5 js-cancel-tip" data-tip="<?php echo $row->content; ?>">
													<?php _e( 'Cancel', 'wpjobster' ); ?>
												</a>

											<?php } ?>

										</div>

									<?php }

								} ?>

							</div>
						</div>
					</div>

				<?php }

			}

		}

		// BUTTONS
		wpj_display_order_action_buttons( array(
			'order'                 => $order,
			'wrapper_class'         => 'order-footer-action-buttons-wrapper',
			'buttons_wrapper_class' => 'div-center-flex',
			'buttons_only'          => false,
			'button_accept_class'   => 'text-button text-button-confirmation',
			'button_deny_class'     => 'text-button text-button-dangerous-soft ml5',
			'button_abort_class'    => 'text-button text-button-dangerous-soft',
			'button1_order'         => 1,
			'button2_order'         => 2
		) );

		// COMPLETED ORDER
		if ( wpj_is_order_completed( $order ) == 1 ) {

			if ( get_current_user_id() == wpj_get_seller_id( $order ) ) { ?>

				<p class="order-info-message">

					<?php echo sprintf( __( "This order is complete. Click %s to contact the buyer", "wpjobster" ), '<a href="' . wpj_get_pm_link( $order->uid ) . '">' . __( "here", "wpjobster" ) . '</a>' ); ?>

				</p>

			<?php } else { ?>

				<p class="order-info-message">

					<?php echo sprintf( __( "This order is complete. Click %s to contact the seller", "wpjobster" ), '<a href="' . wpj_get_pm_link( wpj_get_seller_id( $order ) ) . '">' . __( "here", "wpjobster" ) . '</a>' ); ?>

				</p>

			<?php }

		}

	} else echo '<style>.order-notifications-row-wrapper{display:none;}</style>'; // for page builder ?>

	<!-- ARROW DOWN IMAGE -->
	<div class="arrow-down-wrapper">

		<?php if ( ! in_array( $order->payment_status, array( 'pending', 'failed', 'processing', 'cancelled' ) ) ) {

			if ( wpj_is_order_completed( $order ) != 1 && $order->closed != 1 && $order->force_cancellation != 2 && ! $buyer_arbitration ) {

				if (
					get_current_user_id() != wpj_get_seller_id( $order )
					&& $order->closed != 1
					&& wpj_is_order_delivered( $order ) != 1
					&& $order->request_cancellation_from_seller == 0
					&& $order->request_cancellation_from_buyer == 0
					&& $order->request_modification == 0
					&& ! wpj_order_has_arbitration( $order->id )
					&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
				) { ?>

					<div class="w100 center">
						<img src="<?php echo get_template_directory_uri() . '/assets/images/arrow/arrow-down.png'; ?>" alt="" />
					</div>

				<?php }

			}

		} ?>

	</div>

</div>