<?php
/**
 * @var $order
 * @var $show_timer
 * @var $buyer_arbitration
 * @var $expected
 * @var $instant
 * @var $rtl_clock_dir_class
 * @var $class_arr
 * @var $short_class_arr
 * @var $interval_arr
 */
?>

<div class="order-timer-wrapper">

	<?php if ( $order && $show_timer ) {

		if (
			$order->payment_status != 'pending'
			&& $order->payment_status != 'processing'
			&& $order->closed != 1
			&& ! $buyer_arbitration
			&& (
				( wpj_get_option( 'wpjobster_stop_transaction_clock' ) == 'delivered' && wpj_is_order_delivered( $order ) != 1 )
				|| ( wpj_get_option( 'wpjobster_stop_transaction_clock' ) == 'completed' && wpj_is_order_completed( $order ) != 1 )
			)
		) { ?>

			<div data-expected="<?php echo $expected; ?>" class="cf chatbox-timer <?php if ( wpj_is_order_time_up( $order ) == 1 && $instant != 1 ) { echo "expired"; } ?>">

				<div class="flipTimer<?php echo $rtl_clock_dir_class; ?>">

					<?php foreach ( $class_arr as $key => $class_val ) { ?>

						<div class="<?php echo $class_val; ?>"></div>

					<?php } ?>

				</div>

				<?php if ( wpj_is_order_time_up( $order ) == 1 && $instant != 1 ) { ?>

					<div class="order-late">

						<?php _e( 'This order is LATE', 'wpjobster' ); ?>

					</div>

				<?php } else { ?>

					<div class="contentTimer">

						<?php foreach ( $short_class_arr as $key => $val ) { ?>

							<span class="<?php echo $val; ?>"><?php echo $interval_arr[$key]; ?></span>

						<?php } ?>

					</div>

				<?php } ?>

			</div>

		<?php }

	} ?>

</div>