<?php
/**
 * @var $package_max_days
 * @var $package_nr
 * @var $package_revisions
 * @var $package_name
 * @var $package_description
 * @var $package_custom_fields
 * @var $name
 */
?>

<div class="packages-sidebar no-border">

	<div class="inline-content">
		<div class="start">
			<i class="wait icon"></i>

			<?php echo sprintf( _n( '%d day delivery', '%d days delivery', $package_max_days[$package_nr], 'wpjobster' ), $package_max_days[$package_nr]); ?>

		</div>

		<div class="end">
			<i class="refresh icon"></i>

			<?php if ( $package_revisions[$package_nr] == 'unlimited' ) _e( 'Unlimited revisions', 'wpjobster' );
			else echo sprintf( _n( '%d revision', '%d revisions', $package_revisions[$package_nr], 'wpjobster' ), $package_revisions[$package_nr]); ?>

		</div>
	</div>

	<div class="pck-sidebar-name">

		<?php echo mb_strtoupper( $package_name[$package_nr] ); ?>

	</div>

	<div class="pck-sidebar-desc">

		<?php echo wpj_apply_filter_to_string( $package_description[$package_nr], false, 'joblistings' ); ?>

	</div>

	<div class="pck-sidebar-fields">

		<?php if ( $package_custom_fields ) {
			foreach ( $package_custom_fields as $value ) {
				if ( $value[$name] == 'on' ) { ?>

					<p><i class="checkmark icon"></i><?php echo $value['name']; ?></p>

				<?php }
			}
		} ?>

	</div>

	<a class="pck-sidebar-compare-packages" href="#pc-packages">
        <?php _e( 'Compare Packages', 'wpjobster' ); ?>
    </a>

</div>