<?php
/**
 * @var $pid
 * @var $packages
 * @var $default_package
 * @var $package_price
 * @var $package_name
 * @var $package_description
 * @var $package_custom_fields
 * @var $package_revisions
 * @var $package_max_days
 */

if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' ) { ?>

	<div id="mobile-packages" class="mobile-packages">

		<?php if ( wpj_get_option( 'wpjobster_packages_enabled' ) == "yes" ) { ?>

			<div class="ui pointing secondary packages-tabs menu">

				<?php $i = 0; foreach ( $packages as $key => $package ) { $i++; ?>

					<a
						class="item pck-mobile-select-package <?php echo $key . ( $key == $default_package ? ' active' : '' ); ?>"
						data-tab="<?php echo $package; ?>"
						data-price="<?php echo get_post_meta( $pid, 'package_price', true )[$key]; ?>"
						data-price-formatted="<?php echo wpj_show_price( get_post_meta( $pid, 'package_price', true )[$key] ); ?>"
						data-delivery="<?php echo get_post_meta( $pid, 'package_max_days', true )[$key]; ?>"
					>

						<span class="pck-tab-title"><?php echo ucfirst( $package ); ?></span>

					</a>

				<?php } ?>

			</div>

			<?php foreach ( $packages as $key_c => $package ) {
				$class   = $key_c == $default_package ? 'right labeled' : '';
				$display = $key_c == $default_package ? 'block' : 'none'; ?>

				<div class="ui <?php if ( $key_c == $default_package ) echo 'active'; ?> packages-mobile tab segment" data-tab="<?php echo $package; ?>">

					<div class="pck-name"><?php echo $package_name[$key_c]; ?></div>

					<div class="pck-price"><?php echo wpj_show_price( $package_price[$key_c] ); ?></div>

					<div class="pck-description"><?php echo wpj_apply_filter_to_string( $package_description[$key_c], false, 'joblistings' ); ?></div>

					<div class="pck-include">

						<div class="pck-include-title"><?php _e( 'What\'s included?', 'wpjobster' ); ?></div>

						<ul class="pck-include-list">

							<?php if ( $package_custom_fields ) {

								foreach ( $package_custom_fields as $field ) {

									if ( $field[$package] == 'on' ) { ?>

										<li><i class="checkmark icon"></i><?php echo $field['name']; ?></li>

									<?php }

								}

							} ?>

							<li>

								<i class="checkmark icon"></i>

								<?php if ( $package_revisions[$key_c] == 'unlimited' ) $revisions_nr = __( 'Unlimited', 'wpjobster' );
								elseif ( $package_revisions[$key_c] == 'no_revision' ) $revisions_nr = '0';
								else $revisions_nr = $package_revisions[$key_c];

								echo sprintf( __( 'Revisions: %s', 'wpjobster' ), $revisions_nr ); ?>

							</li>

							<li>

								<i class="checkmark icon"></i>

								<?php echo sprintf( _n( 'Delivery time: %d day', 'Delivery time: %d days', $package_max_days[$key_c], 'wpjobster' ), $package_max_days[$key_c] ); ?>

							</li>

						</ul>

					</div>

				</div>

			<?php }

		} ?>

	</div>

<?php } else echo '<style>.job-packages-row-wrapper{display:none;}</style>'; // for page builder