<?php
/**
 * @var $pid
 * @var $default_package
 * @var $package_price
 * @var $package_name
 * @var $package_description
 * @var $package_custom_fields
 * @var $package_revisions
 * @var $package_max_days
 */

if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' ) { ?>

	<div id="pc-packages" class="pc-packages">

		<?php if ( wpj_get_option( 'wpjobster_packages_enabled' ) == "yes" ) { ?>

			<table class="packages-table">

				<thead>
					<tr>
						<th><?php _e( 'Packages', 'wpjobster' ); ?></th>
						<th id="pck-basic" class="<?php if ( $default_package == 0 ) echo 'active'; ?>"><?php _e( 'BASIC', 'wpjobster' ); ?></th>
						<th id="pck-standard" class="<?php if ( $default_package == 1 ) echo 'active'; ?>"><?php _e( 'STANDARD', 'wpjobster' ); ?></th>
						<th id="pck-premium" class="<?php if ( $default_package == 2 ) echo 'active'; ?>"><?php _e( 'PREMIUM', 'wpjobster' ); ?></th>
					</tr>
				</thead>

				<tbody>

					<tr>
						<td><?php _e( 'Name', 'wpjobster' ); ?></td>

						<?php if ( $package_name ) {
							foreach ( $package_name as $p_n_key => $p_name ) { ?>

								<td class="pck-name <?php if ( $p_n_key == $default_package ) echo 'active'; ?>"><?php echo $p_name; ?></td>

							<?php }
						} ?>
					</tr>

					<tr>
						<td><?php _e( 'Description', 'wpjobster' ); ?></td>

						<?php if ( $package_description ) {
							foreach ( $package_description as $p_d_key => $p_desc ) { ?>

								<td class="<?php if ( $p_d_key == $default_package ) echo 'active'; ?>"><?php echo wpj_apply_filter_to_string( $p_desc, false, 'joblistings' ); ?></td>

							<?php }
						} ?>
					</tr>

					<?php if ( $package_custom_fields ) {
						foreach ( $package_custom_fields as $key => $value ) { ?>

							<tr class="sn-custom-fields">
								<td><?php echo $value['name']; ?></td>

								<td class="pck-center <?php if ( $default_package == 0 ) echo 'active'; ?>">
									<?php if ( $value['basic'] == 'on' ) {
										echo '<i class="checkmark icon"></i>';
									} else {
										echo '<i class="remove icon"></i>';
									} ?>
								</td>

								<td class="pck-center <?php if ( $default_package == 1 ) echo 'active'; ?>">
									<?php if ( $value['standard'] == 'on' ) {
										echo '<i class="checkmark icon"></i>';
									} else {
										echo '<i class="remove icon"></i>';
									} ?>
								</td>

								<td class="pck-center <?php if ( $default_package == 2 ) echo 'active'; ?>">
									<?php if ( $value['premium'] == 'on' ) {
										echo '<i class="checkmark icon"></i>';
									} else {
										echo '<i class="remove icon"></i>';
									} ?>
								</td>

							</tr>

						<?php }
					} ?>

					<tr>
						<td><?php _e( 'Delivery time', 'wpjobster' ); ?></td>

						<?php if ( $package_max_days ) {
							foreach ( $package_max_days as $p_md_key => $p_max_days ) { ?>

								<td class="pck-center <?php if ( $p_md_key == $default_package ) echo 'active'; ?>"><?php echo sprintf( _n( '%d day', '%d days',$p_max_days, 'wpjobster' ), $p_max_days); ?></td>

							<?php }
						} ?>
					</tr>

					<tr>
						<td><?php _e( 'Revisions', 'wpjobster' ); ?></td>

						<?php if ( $package_revisions ) {
							foreach ( $package_revisions as $p_r_key => $p_rev ) { ?>

								<td class="pck-center <?php if ( $p_r_key == $default_package ) echo 'active'; ?>">

									<?php if ( $p_rev == 'unlimited' ) _e( 'Unlimited', 'wpjobster' );
									elseif ( $p_rev == 'no_revision' ) echo '0';
									else echo $p_rev; ?>

								</td>

							<?php }
						} ?>
					</tr>

					<tr>
						<td><?php _e( 'Price', 'wpjobster' ); ?></td>

						<?php if ( $package_price ) {
							foreach ( $package_price as $p_p_key => $p_price ) { ?>

								<td data-price="<?php echo wpj_number_format_special_exchange( $p_price ); ?>" class="pck-center pck-price <?php if ( $p_p_key == $default_package ) echo 'active'; ?>"><?php echo wpj_show_price( $p_price ); ?></td>

							<?php }
						} ?>
					</tr>

					<tr>
						<td><?php _e( 'Order', 'wpjobster' ); ?></td>

						<?php if ( $package_price ) {
							foreach ( $package_price as $p_p_key => $p_price ) { ?>

								<td
									class="pck-center pck-order pck-pc-select-package <?php echo $p_p_key . ( $p_p_key == $default_package ? ' active' : ''); ?>"
									data-price="<?php echo $p_price; ?>"
									data-price-formatted="<?php echo wpj_show_price( $p_price ); ?>"
									data-delivery="<?php echo get_post_meta( $pid, 'package_max_days', true )[$p_p_key]; ?>"
								>
									<div class="ui <?php echo $p_p_key == $default_package ? 'checked' : ''; ?> radio checkbox" style="display: none">
										<input type="radio" name="package_price" class="package_price" <?php echo $p_p_key == $default_package ? 'checked=""' : ''; ?>>
										<label></label>
									</div>
									<button class="text-button text-button-medium"><?php _e( 'Select', 'wpjobster' ); ?></button>
								</td>

							<?php }
						} ?>
					</tr>

				</tbody>

			</table>

		<?php } ?>

	</div>

<?php } else echo '<style>.job-packages-row-wrapper{display:none;}</style>'; // for page builder