<?php
/**
 * @var $instr_arr
 * @var $action_type
 * @var $pid
 * @var $pck_max_days_val
 * @var $pck_revisions_val
 * @var $pck_cf_name_value
 * @var $pck_cf_basic_value
 * @var $checked_basic
 * @var $pck_cf_standard_value
 * @var $checked_standard
 * @var $pck_cf_premium_value
 * @var $checked_premium
 */
?>

<div class="packages">

	<table class="ui compact celled definition table packages-table">

		<thead>
			<tr>
				<th class="empty-package-title"></th>
				<th class="first-package-title"><?php _e( 'BASIC', 'wpjobster' ); ?></th>
				<th class="second-package-title"><?php _e( 'STANDARD', 'wpjobster' ); ?></th>
				<th class="third-package-title"><?php _e( 'PREMIUM', 'wpjobster' ); ?></th>
			</tr>
		</thead>

		<tbody class="package-table-body">
			<tr class="pr">
				<td class="package-name-td">
					<?php _e( 'Package name', 'wpjobster' ); ?>
				</td>

				<?php for ( $i = 0; $i < 3; $i++ ) { ?>

					<td class="<?php echo wpj_get_job_rejected_input( 'package_name', $i ); ?>">
						<div class="ui field input tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'package_name' . $i; ?>">
							<input data-validate="package_name<?php echo $i; ?>" class="package_name" name="package_name[]" type="text" placeholder="<?php _e( 'Package Name', 'wpjobster' ); ?>" value="<?php echo ! empty( $pck_name_val[$i] ) && ! array_intersect( $pck_name_val, ['[', ']', '[]'] ) ? $pck_name_val[$i] : ''; ?>">
						</div>

						<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_name'], $action_type, 'job', $pid, 'package_name', 'package_name' . $i ); ?>

					</td>

				<?php } ?>
			</tr>

			<tr class="pr">
				<td>
					<?php _e( 'Package description', 'wpjobster' ); ?>
				</td>

				<?php for ( $i = 0; $i < 3; $i++ ) { ?>

					<td class="<?php echo wpj_get_job_rejected_input( 'package_description', $i ); ?>">
						<div class="field tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'package_description' . $i; ?>">

							<?php if ( wpj_get_option( 'wpjobster_job_description_type' ) == 'wysiwyg' || wpj_get_option( 'wpjobster_job_description_type' ) == 'tinymce' ) {

								wpj_display_wysiwyg_textarea( $pid, 'package_description[]', 'package_description_' . $i, 'package_description_' . $i . '_toolbar', 'package_description', __( 'Describe the details of your offering', 'wpjobster' ), ( ! empty( $pck_description_val[$i] ) && ! array_intersect( $pck_description_val, ['[', ']', '[]'] ) ? $pck_description_val[$i] : '' ), 'package_description' . $i, 'packages', $i );

							} else { ?>

								<textarea data-validate="package_description<?php echo $i; ?>" class="package_description" name="package_description[]" type="text" placeholder="<?php _e( 'Describe the details of your offering', 'wpjobster' ); ?>"><?php echo ! empty( $pck_description_val[$i] ) && ! array_intersect( $pck_description_val, ['[', ']', '[]'] ) ? $pck_description_val[$i] : ''; ?></textarea>

							<?php } ?>

						</div>

						<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_desc'], $action_type, 'job', $pid, 'package_description', 'package_description' . $i ); ?>

					</td>

				<?php } ?>

			</tr>

			<tr class="pr">
				<td>
					<?php _e( 'Package delivery time', 'wpjobster' ); ?>
				</td>

				<?php for ( $i = 0; $i < 3; $i++ ) { ?>

					<td class="<?php echo wpj_get_job_rejected_input( 'package_max_days', $i ); ?>">
						<div class="tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'package_max_days' . $i; ?>">

							<?php $max_days_val = $pck_max_days_val ? $pck_max_days_val[$i] : ''; ?>

							<select name="package_max_days[]" class="ui dropdown selection">

								<?php for ( $i_count = 1; $i_count <= wpj_get_option( 'wpjobster_job_max_delivery_days' ); $i_count++ ) { ?>

									<option value="<?php echo $i_count ?>" <?php echo ( $i_count == $max_days_val ? ' selected="selected" ' : "" ); ?>>

										<?php echo sprintf( _n( '%d day', '%d days', $i_count, 'wpjobster' ), $i_count ); ?>

									</option>

								<?php } ?>

							</select>

						</div>

						<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_deliv'], $action_type, 'job', $pid, 'package_max_days', 'package_max_days' . $i ); ?>

					</td>

				<?php } ?>
			</tr>

			<tr class="pr">
				<td>
					<?php _e( 'Package Revisions', 'wpjobster' ); ?>
				</td>

				<?php for ( $i = 0; $i < 3; $i++ ) { ?>

					<td class="<?php echo wpj_get_job_rejected_input( 'package_revisions', $i ); ?>">
						<div class="tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'package_revisions' . $i; ?>">

							<?php $revisions_val = $pck_revisions_val ? $pck_revisions_val[$i] : ''; ?>

							<select name="package_revisions[]" class="ui dropdown selection">
								<option <?php if ( $revisions_val == 'unlimited' ) echo 'selected'; ?> value="unlimited"><?php _e( 'Unlimited', 'wpjobster' ); ?></option>

								<?php for ( $i_count = 1; $i_count <= 9; $i_count++ ) { ?>

									<option value="<?php echo $i_count ?>" <?php echo ( $i_count == $revisions_val ? ' selected="selected" ' : "" ); ?>>
										<?php echo $i_count; ?>
									</option>

								<?php } ?>

								<option <?php if ( $revisions_val == 'no_revision' ) echo 'selected'; ?> value="no_revision"><?php _e( 'No revision', 'wpjobster' ); ?></option>

							</select>
						</div>

						<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_rev'], $action_type, 'job', $pid, 'package_revisions', 'package_revisions' . $i ); ?>

					</td>

				<?php } ?>

			</tr>

			<tr class="pr">
				<td>
					<?php echo sprintf( __( 'Package price (%s)', 'wpjobster' ), wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ) ); ?>
				</td>

				<?php for ( $i = 0; $i < 3; $i++ ) { ?>

					<td class="pck-padd-left <?php echo wpj_get_job_rejected_input( 'package_price', $i ); ?>">
						<div class="ui labeled field input tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'package_price' . $i; ?>">

							<div class="ui label"><?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?></div>
							<input data-validate="package_price<?php echo $i; ?>" class="package_price" step="0.01" name="package_price[]" type="number" placeholder="<?php _e( 'Package price', 'wpjobster' ); ?>" value="<?php echo ! empty( $pck_price_val[$i] ) ? $pck_price_val[$i] : ''; ?>">
						</div>

						<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_price'], $action_type, 'job', $pid, 'package_price', 'package_price' . $i ); ?>

					</td>

				<?php } ?>

			</tr>

			<tr class="pck-repeater pr">

				<td>

					<div class="tooltip-handler js-tooltip-handler di" data-handler-id="<?php echo 'pck-inp-custom-name'; ?>">
						<div class="ui transparent icon input">
							<input class="pck-inp-custom-name" name="pck-inp-custom-name[]" placeHolder="<?php _e( 'Insert field name', 'wpjobster' ); ?>" value="<?php echo $pck_cf_name_value; ?>" />
							<i class="pck-icon-rem remove icon"></i>
						</div>
					</div>

					<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_cf_name'], $action_type, 'job', $pid, 'pck-inp-custom-name', 'pck-inp-custom-name' ); ?>

				</td>

				<td class="pck-center">

					<div class="ui checkbox tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'pck-chk-value-basic'; ?>">
						<input type="hidden" name="pck-chk-value[basic][]" value="<?php echo $pck_cf_basic_value == 'on' ? 'on' : 'off'; ?>" />
						<input type="checkbox" class="basic-checkbox pck_cf_chk" value="on" <?php echo $checked_basic; ?> />
						<label></label>
					</div>

					<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_cf_chk'], $action_type, 'job', $pid, 'pck-chk-value-basic', 'pck-chk-value-basic' ); ?>

				</td>

				<td class="pck-center">

					<div class="ui checkbox tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'pck-chk-value-standard'; ?>">
						<input type="hidden" name="pck-chk-value[standard][]" value="<?php echo $pck_cf_standard_value == 'on' ? 'on' : 'off'; ?>" />
						<input type="checkbox" class="standard-checkbox pck_cf_chk" value="on" <?php echo $checked_standard; ?> />
						<label></label>
					</div>

					<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_cf_chk'], $action_type, 'job', $pid, 'pck-chk-value-standard', 'pck-chk-value-standard' ); ?>

				</td>

				<td class="pck-center">

					<div class="ui checkbox tooltip-handler js-tooltip-handler" data-handler-id="<?php echo 'pck-chk-value-premium'; ?>">
						<input type="hidden" name="pck-chk-value[premium][]" value="<?php echo $pck_cf_premium_value == 'on' ? 'on' : 'off'; ?>" />
						<input type="checkbox" class="premium-checkbox pck_cf_chk" value="on" <?php echo $checked_premium; ?> />
						<label></label>
					</div>

					<?php if ( isset( $instr_arr[0] ) ) wpj_display_popup_content( $instr_arr[0]['pck_cf_chk'], $action_type, 'job', $pid, 'pck-chk-value-premium', 'pck-chk-value-premium' ); ?>

				</td>
			</tr>

		</tbody>

	</table>

	<!-- ADD NEW CUSTOM FIELD - LINK -->
	<div class="field">
		<a id="add_pck_custom_field" class="cursor-pointer"><?php _e( "+ Add New Custom Field", "wpjobster" ); ?></a>
	</div>
	<!-- END ADD NEW CUSTOM FIELD - LINK -->

</div>