<?php
/**
 * @var $packages_arr
 * @var $default_package
 * @var $package_price
 * @var $package_max_days
 * @var $package_revisions
 * @var $package_name
 * @var $package_description
 * @var $package_custom_fields
 * @var $pid
 */
?>

<div class="ui accordion packages-sidebar">

	<?php foreach ( $packages_arr as $arr_key => $name ) { ?>

		<div class="title <?php echo $arr_key . ' ' . ( $arr_key == $default_package ? 'active' : '' ); ?>">
			<div class="pck-sidebar-title">
				<span class="pck-price-sidebar"><?php echo wpj_show_price( $package_price[$arr_key] ); ?></span>
				<span class="pck-title-sidebar"><?php echo $name; ?></span>
				<div class="right-icon"><i class="angle right icon"></i></div>
			</div>
		</div>

		<div class="content <?php echo $arr_key == $default_package ? 'active' : ''; ?>">
			<p class="transition hidden">

				<div class="inline-content">
					<div class="start">
						<i class="wait icon"></i>

						<?php echo sprintf( _n( '%d Day Delivery', '%d Days Delivery', $package_max_days[$arr_key], 'wpjobster' ), $package_max_days[$arr_key]); ?>

					</div>

					<div class="end">
						<i class="refresh icon"></i>

						<?php if ( $package_revisions[$arr_key] == 'unlimited' ) _e( 'Unlimited Revisions', 'wpjobster' );
						else echo sprintf( _n( '%d Revision', '%d Revisions',$package_revisions[$arr_key], 'wpjobster' ), $package_revisions[$arr_key]); ?>

					</div>
				</div>

				<div class="pck-sidebar-name">

					<?php echo mb_strtoupper( $package_name[$arr_key] ); ?>

				</div>

				<div class="pck-sidebar-desc">

					<?php echo wpj_apply_filter_to_string( $package_description[$arr_key], false, 'joblistings' ); ?>

				</div>

				<div class="pck-sidebar-fields">

					<?php if ( $package_custom_fields ) {
						foreach ( $package_custom_fields as $value ) {
							if ( $value[strtolower( $name )] == 'on' ) { ?>

								<p><i class="checkmark icon"></i><?php echo $value['name']; ?></p>

							<?php }
						}
					} ?>

				</div>

				<button
					class="text-button text-button-highlighted text-button-wide pck-sidebar-dropdown-select-package <?php echo $arr_key . ' ' . ( $arr_key == $default_package ? 'right labeled' : '' ); ?>"
					data-price="<?php echo get_post_meta( $pid, 'package_price', true )[$arr_key]; ?>"
					data-price-formatted="<?php echo wpj_show_price( get_post_meta( $pid, 'package_price', true )[$arr_key] ); ?>"
					data-delivery="<?php echo get_post_meta( $pid, 'package_max_days', true )[$arr_key]; ?>"
				>

					<?php _e( 'Select this package', 'wpjobster' ); ?>

					<i class="checkmark icon right-icon" style="display: <?php echo $arr_key == $default_package ? 'block' : 'none'; ?>"></i>

				</button>

				<a class="pck-sidebar-compare-packages" href="#pc-packages">
                    <?php _e( 'Compare Packages', 'wpjobster' ); ?>
                </a>
			</p>
		</div>

	<?php } ?>

</div>