<?php
/**
 * @var $post_author
 * @var $row_seller
 */
?>

<!-- Feedback by seller -->
<div class="feedback-item feedback-answer">

	<?php wpj_display_user_photo( array( 'uid' => $post_author, 'width' => 80, 'height' => 80, 'with_level_image' => false, 'link_class' => 'job-feedback-picture' ) ); ?>

	<div class="feedback-content">

		<div class="feedback-content-header">

			<div class="start">

				<div class="title">

					<a href="<?php echo wpj_get_user_profile_link( $post_author ); ?>">

						<?php echo wpj_get_user_display_type( $post_author );

						if ( $row_seller->pid != get_the_ID() ) { ?>

							<span class="fw400 color-686e77"><?php _e( '(custom job)', 'wpjobster' ); ?></span>

						<?php } ?>

					</a>

				</div>

				<div class="date">

					<?php echo wpj_date( wpj_get_option( 'date_format' ), $row_seller->datemade ); ?>

				</div>

			</div>

			<div class="end">

				<div class="single-job-rating-stars">

					<?php wpj_display_rating_stars( $row_seller->grade ); ?>

				</div>

			</div>

		</div>

		<div class="feedback-content-text">

			<?php echo wpj_apply_filter_to_string( wpj_stripslashes( str_replace( '\n', '<br>', $row_seller->reason ) ), false, 'userprofiles' ); ?>

		</div>

	</div>

</div>