<?php
/**
 * @var $jobs_count
 * @var $orders_rejection_number
 */

if ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' ) {

	if ( $jobs_count >= $orders_rejection_number ) { ?>

		<div
			class="mb10 mt10 unresponsive-label"
			data-inverted=""
			data-tooltip="<?php echo sprintf( __( 'This seller has %d %s they did not answer', 'wpjobster' ), $jobs_count, _n( "job", "jobs", $jobs_count, "wpjobster" ) ); ?>" data-position="<?php echo is_rtl() ? 'top right' : 'top center'; ?>"
		>

			<div class="ui circular red label">

				<?php _e( 'Unresponsive', 'wpjobster' ); ?>

			</div>

		</div>

	<?php }

}