<?php
/**
 * @var $post
 * @var $pid
 * @var $display_custom_offer
 * @var $r
 */

if ( $post->post_author == get_current_user_id() ) {

	wpj_display_request_activate_deactivate_button( $pid );

	wpj_display_request_edit_button( $pid );

	wpj_display_request_delete_button( $pid );

} elseif ( $display_custom_offer ) {

	if ( is_user_logged_in() ) {

		wpj_display_custom_offer_button( array(
			'unique_id'       => 'request_send_' . $pid,
			'id'              => $pid,
			'title'           => __( 'Send Custom Offer', 'wpjobster' ),
			'offer_type'      => 'send',
			'current_user_id' => get_current_user_id(),
			'post_author_id'  => $post->post_author,
			'page'            => 'single_request'
		) );

		if ( count( $r ) <= 0 && get_current_user_id() == $post->post_author ) { ?>

			<div class="pm-holder pt30"><?php _e( 'No offers here.', 'wpjobster' ); ?></div>

		<?php } elseif ( get_current_user_id() == $post->post_author ) { ?>

			<div class="pm-holder pt30"><?php _e( 'Scroll down to check offers.', 'wpjobster' ); ?></div>

		<?php }

	}

}