<?php
/**
 * @var $page_url
 * @var $filter_term
 * @var $val_term
 * @var $filter_location
 * @var $val_latitude
 * @var $val_longitude
 * @var $val_location
 * @var $filter_radius
 * @var $op_radius_type
 * @var $val_radius
 * @var $filter_category
 * @var $val_category
 * @var $filter_tag
 * @var $op_tags
 * @var $filter_min_rating
 * @var $min_rating_arr
 * @var $val_min_rating
 * @var $filter_price_type
 * @var $price_type_arr
 * @var $val_price_type
 * @var $filter_price
 * @var $filter_price_min
 * @var $val_min_price
 * @var $filter_price_max
 * @var $val_max_price
 * @var $op_empty_budget
 * @var $val_budget_toggle
 * @var $filter_user_level
 * @var $user_levels_arr
 * @var $val_user_level
 * @var $user_levels_arr
 * @var $filter_user_status
 * @var $user_statuses_arr
 * @var $val_user_status
 * @var $filter_deadline
 * @var $val_deadline
 * @var $filter_date
 * @var $val_start_date
 * @var $val_end_date
 * @var $op_empty_date
 * @var $val_date_toggle
 * @var $filter_delivery
 * @var $val_max_days
 * @var $op_empty_delivery
 * @var $val_delivery_toggle
 * @var $page
 */
?>

<div class="full-width-search-form-wrapper">

	<form method="get" class="ui form filter-container js-job-filter-form" action="<?php echo $page_url; ?>">

		<div class="ui grid stackable doubling five column row">

			<!-- Term -->
			<?php if ( $filter_term ) { ?>

				<div class="column">
					<div class="field">
						<div class="ui left labeled icon input term-field">
							<input type="text" placeholder="<?php _e( 'Search Term', 'wpjobster' ); ?>" value="<?php echo $val_term; ?>" name="term" />

							<div class="ui label filter-box search-mobile-icon">
								<i class="filter icon mr0"></i>
							</div>

							<i class="search icon search-desktop-icon"></i>
						</div>
					</div>
				</div>

			<?php } ?>

			<!-- Location -->
			<?php if ( $filter_location ) { ?>

				<div class="column">

					<div class="field">
						<div class="ui search js-location-autocomplete">
							<div class="ui left icon clearable input">
								<input class="prompt fw400 ten wide column" type="text" data-replaceplaceholder="<?php _e( 'Select a valid location', 'wpjobster' ); ?>" placeholder="<?php _e( 'Location', 'wpjobster' ); ?>" id="location_input" value="<?php echo $val_location; ?>" name="location">
								<input id="lat" type="hidden" name="latitude" value="<?php echo $val_latitude; ?>">
								<input id="long" type="hidden" name="longitude" value="<?php echo $val_longitude; ?>">
								<i class="map marker alternate icon"></i>
							</div>
							<div class="results"></div>
						</div>
					</div>

				</div>

				<!-- Radius -->
				<?php if ( $filter_radius ) { ?>

					<div class="column">

						<div class="field">
							<div class="ui left icon clearable input">
								<input class="fw400" type="text" data-replaceplaceholder="<?php _e( 'Insert a valid number', 'wpjobster' ); ?>" data-replaceplaceholder2="<?php _e( 'Select a location first', 'wpjobster' ); ?>" placeholder="<?php echo sprintf( __( "Radius (%s)", "wpjobster" ), wpj_translate_string( $op_radius_type ) ); ?>" id="location_input_radius" value="<?php echo $val_radius; ?>" name="radius">

								<i class="location arrow icon"></i>
							</div>
						</div>

					</div>

				<?php }

			} ?>

			<!-- Categories -->
			<?php if ( $filter_category ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field">

						<?php wpj_display_categories_and_subcategories_select( 'job_cat', 'slug', __( 'Categories', 'wpjobster' ), '', 'category', '', $val_category ); ?>

					</div>

				</div>

			<?php } ?>

			<!-- Tags -->
			<?php if ( $filter_tag ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field">
						<select style="display: none;" class="ui fluid search selection dropdown" name="tag[]" multiple="">
							<option value=""><?php _e( 'Tag', 'wpjobster' ); ?></option>

							<?php foreach ( $op_tags as $key => $tag ) { ?>

								<option value="<?php echo $tag->slug; ?>"><?php echo $tag->name; ?></option>

							<?php } ?>

						</select>
					</div>

				</div>

			<?php } ?>

			<!-- Minimum Rating -->
			<?php if ( $filter_min_rating ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field">
						<select name="min_rating" class="ui clearable dropdown">
							<option value=""><?php _e( 'Minimum Rating', 'wpjobster' ); ?></option>

							<?php foreach ( $min_rating_arr as $key => $min_rating ) { ?>

								<option <?php echo $key == $val_min_rating ? "selected='selected'" : ""; ?> value="<?php echo $key; ?>"><?php echo $min_rating; ?></option>

							<?php } ?>

						</select>
					</div>

				</div>

			<?php } ?>

			<!-- Price Type -->
			<?php if ( $filter_price_type ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field">
						<select name="price_type" class="ui clearable dropdown">
							<option value=""><?php _e( 'Price type', 'wpjobster' ); ?></option>

							<?php foreach ( $price_type_arr as $key => $price_type ) {

								if (
									( wpj_get_option( 'wpjobster_enable_' . $price_type . '_rate' ) == 'yes' && $price_type != 'package' )
									|| ( $price_type == 'package' && wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' )
								) { ?>

									<option <?php echo $price_type == $val_price_type ? "selected='selected'" : ""; ?> value="<?php echo strtolower( $price_type ); ?>"><?php echo strtolower( wpj_translate_string( $price_type ) ); ?></option>

								<?php }

							} ?>

						</select>
					</div>

				</div>

			<?php } ?>

			<!-- Price -->
			<?php if ( $filter_price ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="two fields">

						<!-- Price Min -->
						<?php if ( $filter_price_min ) { ?>

							<div class="field">
								<div class="ui clearable input">
									<input class="fw400" type="text" name="min_price" placeholder="<?php _e( 'Min Price', 'wpjobster' ); ?>" value="<?php echo $val_min_price; ?>" />
								</div>
							</div>

						<?php } ?>

						<!-- Price Max -->
						<?php if ( $filter_price_max ) { ?>

							<div class="field">
								<div class="ui clearable input">
									<input class="fw400" type="text" name="max_price" placeholder="<?php _e( 'Max Price', 'wpjobster' ); ?>" value="<?php echo $val_max_price; ?>" />
								</div>
							</div>

						<?php } ?>

					</div>

					<!-- Price Toggle -->
					<?php if ( $op_empty_budget == 'always' ) { ?>

						<input type="hidden" name="without_budget" value="yes" />

					<?php } elseif ( $op_empty_budget == 'ifchecked' ) { ?>

						<div class="field">
							<div class="ui toggle checkbox">
								<input type="checkbox" name="without_budget" <?php echo $val_budget_toggle == 'yes' ? 'checked' : ''; ?> value="yes" />
								<label><?php _e( 'Include undefined budget' ,'wpjobster' ); ?></label>
							</div>
						</div>

					<?php } ?>

				</div>

			<?php } ?>

			<!-- User Level -->
			<?php if ( $filter_user_level ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field">
						<select name="user_level" class="ui clearable dropdown">
							<option value=""><?php _e( 'User Level', 'wpjobster' ); ?></option>

							<?php foreach ( $user_levels_arr as $key => $user_level ) { ?>

								<option <?php echo is_numeric( $val_user_level ) && $key == $val_user_level ? "selected='selected'" : ""; ?> value="<?php echo $key; ?>"><?php echo $user_level; ?></option>

							<?php } ?>

						</select>
					</div>

				</div>

			<?php } ?>

			<!-- User status -->
			<?php if ( $filter_user_status ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field">
						<select name="user_status" class="ui clearable dropdown">
							<option value=""><?php _e( 'User Status', 'wpjobster' ); ?></option>

							<?php foreach ( $user_statuses_arr as $key => $user_status ) { ?>

								<option <?php echo $key == $val_user_status ? "selected='selected'" : ""; ?> value="<?php echo $key; ?>"><?php echo $user_status; ?></option>

							<?php } ?>

						</select>
					</div>

				</div>

			<?php } ?>

			<!-- Deadline -->
			<?php if ( $filter_deadline ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field">
						<div class="ui calendar js-calendar">
							<div class="ui input left icon">
								<i class="calendar alternate outline icon"></i>
								<input class="fw400" type="text" placeholder="<?php _e( 'Deadline', 'wpjobster' ); ?>" id="deadline_input" value="<?php echo $val_deadline; ?>" name="deadline">
							</div>
						</div>
					</div>

				</div>

			<?php } ?>

			<!-- Date -->
			<?php if ( $filter_date == 'yes' ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="two fields">
						<!-- Date Start -->
						<div class="field">
							<div class="ui calendar js-calendar">
								<div class="ui input left icon">
									<i class="calendar alternate outline icon"></i>
									<input class="fw400" type="text" placeholder="<?php _e( 'Start date', 'wpjobster' ); ?>" value="<?php echo $val_start_date; ?>" name="start_date" id="start_date_input">
								</div>
							</div>
						</div>

						<!-- Date End -->
						<div class="field">
							<div class="ui calendar js-calendar">
								<div class="ui input left icon">
									<i class="calendar alternate outline icon"></i>
									<input class="fw400" type="text" placeholder="<?php _e( 'End date', 'wpjobster' ); ?>" value="<?php echo $val_end_date; ?>" name="end_date" id="end_date_input">
								</div>
							</div>
						</div>
					</div>

					<!-- Date Toggle -->
					<?php if ( $op_empty_date == 'always' ) { ?>

						<input type="hidden" name="without_date" value="yes" />

					<?php } elseif ( $op_empty_date == 'ifchecked' ) { ?>

						<div class="field">
							<div class="ui toggle checkbox">
								<input type="checkbox" name="without_date" <?php echo $val_date_toggle == 'yes' ? 'checked' : ''; ?> value="yes" />
								<label><?php _e( 'Include undefined date' ,'wpjobster' ); ?></label>
							</div>
						</div>

					<?php } ?>

				</div>

			<?php } ?>

			<!-- Action -->
			<?php do_action( 'wpj_before_delivery_field_search_sidebar' ); ?>

			<!-- Delivery -->
			<?php if ( $filter_delivery ) { ?>

				<div class="column js-group-filters collapse-filters">

					<div class="field inline-field">
						<label for="max-days-title" class="label">

							<?php _e( "Delivery", "wpjobster" ); ?>

							<span id="amount-label" class="small-label">

								<?php _e( '(days)', 'wpjobster' ); ?>

							</span>

						</label>

						<input type="text" id="amount" name="max_days" readonly class="max-days-input" value="<?php echo $val_max_days; ?>" />

					</div>

					<!-- Delivery Slider -->
					<div class="field">
						<div id="slider-range-min" data-value="<?php echo $val_max_days; ?>"></div>
					</div>

					<!-- Instant/Empty Delivery -->
                    <div class="column js-group-filters collapse-filters">

                        <!-- Delivery Toggle -->
                        <?php if ( $op_empty_delivery == 'always' ) { ?>

                            <input type="hidden" name="without_delivery" value="yes" />

                        <?php } elseif ( $op_empty_delivery == 'ifchecked' ) { ?>

                            <div class="field">
                                <div class="ui toggle checkbox inline-toggle">
                                    <input type="checkbox" name="without_delivery" <?php echo $val_delivery_toggle == 'yes' ? 'checked' : ''; ?> value="yes" />
                                    <label><?php _e( 'Include undefined delivery' ,'wpjobster' ); ?></label>
                                </div>
                            </div>

                        <?php } ?>

                    </div>

				</div>

			<?php } ?>

			<div class="column">

				<!-- Action -->
				<?php do_action( 'wpj_before_filter_results_button', $page ); ?>

				<!-- Filter Results Button -->
				<div class="field">
					<input class="ui fluid primary button full-width no-margin bigger" type="submit" value="<?php _e( 'Filter Results', 'wpjobster' ); ?>" name="research_me" />
				</div>

			</div>

		</div>

		<!-- Switch to Filter -->
		<?php if ( isset( $_COOKIE['switch_filter'] ) && WPJ_Form::get( 'price_type' ) != 'package' ) { ?>

			<input type="hidden" name="switch_filter" value="<?php echo WPJ_Form::cookie( 'switch_filter' ); ?>" />

		<?php } ?>

	</form>

</div>