<?php
/**
 * @var $classes
 * @var $sort_by_value
 * @var $page
 * @var $location_get
 * @var $latitude_get
 * @var $longitude_get
 */
?>

<div class="sort-by-section">

	<?php if ( strpos( $classes, 'slim-dropdown' ) !== false ) { ?>

		<div class="slim-dropdown-wrapper">

			<label><?php _e( "Sort by", "wpjobster" ); ?></label>

	<?php } ?>

			<select class="ui dropdown filter-results-by <?php echo $classes; ?>">

				<?php if ( strpos( $classes, 'slim-dropdown' ) === false ) { ?>

					<option value=""><?php _e( "Sort by", "wpjobster" ); ?></option>

				<?php } ?>

				<option <?php echo $sort_by_value == 'auto' ? 'selected="selected"' : ''; ?> value="auto"><?php _e( "Auto", "wpjobster" ); ?></option>
				<option <?php echo $sort_by_value == 'new' ? 'selected="selected"' : ''; ?> value="new"><?php _e( "Newest", "wpjobster" ); ?></option>
				<option <?php echo $sort_by_value == 'old' ? 'selected="selected"' : ''; ?> value="old"><?php _e( "Oldest", "wpjobster" ); ?></option>

				<?php if ( $page == 'job' || $page == 'user' ) { ?>

					<option <?php echo $sort_by_value == 'rating' ? 'selected="selected"' : ''; ?> value="rating"><?php _e( "Rating", "wpjobster" ); ?></option>

					<?php if ( $page == 'job' ) { ?>

						<option <?php echo $sort_by_value == 'reviews' ? 'selected="selected"' : ''; ?> value="reviews"><?php _e( "Reviews number", "wpjobster" ); ?></option>

						<?php if ( wpj_get_option( 'wpjobster_enable_job_views' ) == 'yes' ) { ?>

							<option <?php echo $sort_by_value == 'views' ? 'selected="selected"' : ''; ?> value="views"><?php _e( "Views: most visits first", "wpjobster" ); ?></option>

						<?php } ?>

						<option <?php echo $sort_by_value == 'price_lowest' ? 'selected="selected"' : ''; ?> value="price_lowest"><?php _e( "Price: lowest first", "wpjobster" ); ?></option>
						<option <?php echo $sort_by_value == 'price_highest' ? 'selected="selected"' : ''; ?> value="price_highest"><?php _e( "Price: highest first", "wpjobster" ); ?></option>

					<?php }

					if ( $page == 'user' ) { ?>

						<option <?php echo $sort_by_value == 'sales' ? 'selected="selected"' : ''; ?> value="sales"><?php _e( "Sales number", "wpjobster" ); ?></option>

					<?php }

				}

				if (
					(
						( $page == 'job' && wpj_get_option( 'wpjobster_location' ) == 'yes' )
						|| ( $page == 'request' && wpj_get_option( 'wpjobster_request_location' ) == 'yes' )
					)
					&& $location_get && $latitude_get && $longitude_get
				) { ?>

					<option <?php echo WPJ_Form::cookie( 'switch_filter' ) == 'distance' ? 'selected="selected"' : ''; ?> value="distance"><?php _e( "Distance: nearest first", "wpjobster" ); ?></option>

				<?php } ?>

			</select>

	<?php if ( strpos( $classes, 'slim-dropdown' ) !== false ) { ?>

		</div>

	<?php } ?>

</div>