<?php
/**
 * @var $is_subscribed
 * @var $column1
 * @var $column2
 * @var $current_level
 * @var $subscription_eligibility_enabled
 * @var $subscription_levels
 * @var $features
 * @var $current_type
 * @var $current_subscription
 * @var $subscription_order
 */

if ( $is_subscribed == 1 ) { ?>

	<div class="ui grid two-column-table">

		<div class="<?php echo $column1; ?> column heading"><?php _e( "Subscription", "wpjobster" ); ?></div>
		<div class="<?php echo $column2; ?> column"><?php echo wpj_translate_string( $current_level ); ?></div>

		<div class="<?php echo $column1; ?> column heading"><?php _e( "Eligibility", "wpjobster" ); ?></div>
		<div class="<?php echo $column2; ?> column">

			<?php if ( $subscription_eligibility_enabled == 'yes' && $subscription_levels[$current_level]['eligility'] && $subscription_levels[$current_level]['eligility'] != '0' ) {

				echo sprintf( __( 'Minimum amount of sales: %s', 'wpjobster' ), wpj_show_price( $subscription_levels[$current_level]['eligility'] ) );

			} else {

				_e( "NA", "wpjobster" );

			} ?>

		</div>

		<div class="sixteen wide mobile three wide computer column heading"><?php _e( "Features", "wpjobster" ); ?></div>
		<div class="sixteen wide mobile thirteen wide computer column">

			<div class="ui stackable two column grid">

				<?php if ( $features ) {

					foreach ( $features as $f_key => $feature ) { $slug = $feature['slug'];

						$feature_value = $subscription_levels[$current_level][$slug];

						if ( $slug == 'max_extra_price' || $slug == 'max_job_price' || $slug == 'max_ce_price' || $slug == 'min_extra_price' || $slug == 'min_job_price' || $slug == 'min_ce_price' ) {
							$f_value = $feature_value ? wpj_show_price( $feature_value ) : '0';

						} elseif ( $slug == 'fees' ) {
							$f_value = $feature_value ? $feature_value . '%' : '-';

						} elseif ( $slug == 'icon_url' ) {
							$f_value = $feature_value ? '<img src="' . $feature_value . '" width="25" />' : '-';

						} else {
							$f_value = $feature_value ? wpj_translate_string( $feature_value ) : '-';

						} ?>

						<div class="subscr-features-list vertical-align-middle column">
							<i class="checkmark icon"></i>
							<?php echo $feature['label'] . ": " . $f_value; ?><br>
						</div>

					<?php }

				} ?>

			</div>

		</div>

		<div class="<?php echo $column1; ?> column heading"><?php _e( "Billing Period", "wpjobster" ); ?></div>
		<div class="<?php echo $column2; ?> column"><?php echo wpj_translate_string( $current_type ); ?></div>

		<div class="<?php echo $column1; ?> column heading"><?php _e( "Next Billing Date", "wpjobster" ); ?></div>
		<div class="<?php echo $column2; ?> column"><?php if ( strtolower( $current_type ) == 'lifetime' ) { _e( 'NA', 'wpjobster' ); } else { echo $current_subscription->next_billing_date; } ?></div>

	</div>

	<?php if ( $subscription_order ) { ?>

		<div class="ui section divider"></div>

		<a class="text-button text-button-negative cancel-subscription-button" onclick="clickAndDisable( this ); take_to_gateway_subscription_process( 'cancel', '<?php echo $subscription_order->id; ?>', '<?php echo $subscription_order->payment_gateway_name; ?>' );">

			<?php _e( 'Cancel subscription', 'wpjobster' ); ?>

		</a>

		<?php do_action( 'wpj_after_cancel_subscription_button', $subscription_order );

	}

}