<?php
/**
 * @var $is_subscribed
 * @var $action_type
 * @var $subscription_levels
 * @var $subscription_eligibility_enabled
 * @var $current_user_sales
 * @var $padding
 * @var $features
 * @var $pending_subscription
 * @var $current_level
 * @var $current_type
 */

if ( $is_subscribed == 0 || ( $is_subscribed == 1 && $action_type != 'new-subscription' ) ) { ?>

	<div class="subscription-wrapper js-subscription-wrapper subscription-mobile-wrapper">

		<form action="<?php echo get_permalink( wpj_get_option( 'wpjobster_subscriptions_page_id' ) ); ?>" method="GET">

			<input type="hidden" name="action" value="<?php echo $action_type; ?>" />

			<?php if ( $action_type == 'schedule-subscription' ) { ?>

				<input type="hidden" name="schedule_only" value ="1" />

			<?php } ?>

			<div id="subscription-packages" class="mobile-subscription-packages">

				<div class="ui pointing secondary packages-tabs menu">

					<?php foreach ( $subscription_levels as $key => $value ) {

						if ( wpj_subscription_package_enabled( $key ) ) { ?>

							<a class="<?php if ( $key == 'level1' ) echo 'active'; ?> item" data-tab="<?php echo $key; ?>">
								<span class="pck-tab-title">

									<?php echo wpj_translate_string( $key ); ?>

								</span>
							</a>

						<?php }

					} ?>

				</div>

				<?php foreach ( $subscription_levels as $key_s => $value_s ) { ?>

					<div class="ui <?php if ( $key_s == 'level1' ) echo 'active'; ?> packages-mobile tab segment" data-tab="<?php echo $key_s; ?>">

						<?php // Subscription eligibility
						if ( $subscription_eligibility_enabled == 'yes' ) { ?>

							<!-- Minimum amount of sales -->
							<div class="subscr-min-sales-amount">

								<?php echo sprintf( __( 'Minimum amount of sales: %s', 'wpjobster' ), $subscription_levels[$key_s]['eligility'] ? wpj_show_price( $subscription_levels[$key_s]['eligility'] ) : __( 'NA', 'wpjobster' ) ); ?>

							</div>

							<!-- Current amount -->
							<span class="subscr-current-amount">
								<strong>

									<?php echo sprintf( __( 'Current amount of sales: %s', 'wpjobster' ), wpj_show_price( $current_user_sales ) ); ?>

								</strong>
							</span>

							<!-- Eligibility -->
							<?php if ( wpj_subscription_package_enabled( $key_s ) ) { $is_eligibility = true; ?>

								<span class="subscr-eligibility">

									<?php if ( $subscription_levels[$key_s]['eligility'] ) {

										if ( wpj_number_format_special( $current_user_sales, 2 ) >= wpj_number_format_special( $subscription_levels[$key_s]['eligility'], 2 ) ) { ?>

											<font class="fw700" style="color: #2c662d;"><?php _e( "ELIGIBLE", "wpjobster" ); ?></font>

										<?php } else { ?>

											<font class="fw700" style="color: #9f3a38;"><?php _e( "NOT ELIGIBLE", "wpjobster" ); ?></font>

										<?php }

									} ?>

								</span>

							<?php }

						} ?>

						<!-- Features -->
						<div class="subscr-pck-include">

							<div class="subscr-pck-include-title<?php echo $padding; ?>">

								<?php echo sprintf( __( '%s - What\'s included?', 'wpjobster' ), wpj_translate_string( $key_s ) ); ?>

							</div>

							<table class="ui unstackable table">

								<?php if ( $features ) {

									foreach ( $features as $f_key => $feature ) { $slug = $feature['slug']; ?>

										<tr>
											<td><?php echo $feature['label'] . ': '; ?></td>

											<td class="text-center">

												<?php if ( wpj_subscription_package_enabled( $key_s ) ) {
													if ( $slug == 'icon_url' ) {
														echo $value_s[$slug] ? '<img src="' . $value_s[$slug] . '" width="25" />' : '-';

													} elseif ( $slug == 'max_extra_price' || $slug == 'max_job_price' || $slug == 'max_ce_price' || $slug == 'min_extra_price' || $slug == 'min_job_price' || $slug == 'min_ce_price' ) {
														echo $value_s[$slug] ? wpj_show_price( $value_s[$slug] ) : '0';

													} elseif ( $slug == 'fees' ) {
														echo $value_s[$slug] ? $value_s[$slug]. '%' : '-';

													} else {
														echo $value_s[$slug] ? wpj_translate_string( $value_s[$slug] ) : '-';

													}
												} ?>

											</td>
										</tr>

									<?php }
								}

								// New features hook
								do_action( 'wpj_before_subscription_billing_period', $subscription_levels, $key_s, 'mobile' ); ?>

							</table>
						</div>

						<?php if ( $pending_subscription ) { ?>

							<!-- Pending payment -->
							<div class="subscr-pck-include-title pt20">

								<?php _e( 'Pending payment', 'wpjobster' ); ?>

							</div>

							<p><?php _e( 'You already have a subscription whose payment is pending.', 'wpjobster' ); ?></p>

							<div class="ui mini buttons">
								<button class="ui negative button" onclick="take_to_gateway_subscription_process( 'cancel', '<?php echo $pending_subscription->id; ?>', '<?php echo $pending_subscription->payment_gateway_name; ?>' )"><?php _e( 'Cancel', 'wpjobster' ); ?></button>

								<?php if ( $pending_subscription->payment_gateway_name != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $pending_subscription->payment_gateway_name ) ) { ?>

									<div class="or" data-text="<?php _e( 'or', 'wpjobster' ); ?>"></div>

									<button class="ui positive button" onclick="event.preventDefault(); take_to_gateway_subscription_process( 'process', '<?php echo $pending_subscription->id; ?>', '<?php echo $pending_subscription->payment_gateway_name; ?>' )"><?php _e( 'Process', 'wpjobster' ); ?></button>

								<?php } ?>

							</div>

						<?php } else { ?>

							<!-- Billing period -->
							<div class="subscr-pck-include-title pt20">

								<?php _e( 'Billing period', 'wpjobster' ); ?>

							</div>

							<div class="subscr-billing-period">

								<?php wpj_display_subscription_billing_period( 'mobile', $subscription_levels , $key_s, $is_subscribed, $action_type, $current_level, $current_type ); ?>

							</div>

						<?php } ?>

					</div>

				<?php } ?>

			</div>

		</form>

	</div>

<?php }