<?php
/**
 * @var $is_subscribed
 * @var $action_type
 * @var $subscription_levels
 * @var $subscription_eligibility_enabled
 * @var $current_user_sales
 * @var $features
 * @var $pending_subscription
 * @var $current_level
 * @var $current_type
 * @var $subscription_packages_number
 */

if ( $is_subscribed == 0 || ( $is_subscribed == 1 && $action_type != 'new-subscription' ) ) { ?>

	<div class="subscription-wrapper js-subscription-wrapper subscription-pc-wrapper">

		<form action="<?php echo get_permalink( wpj_get_option( 'wpjobster_subscriptions_page_id' ) ); ?>" method="GET">

			<input type="hidden" name="action" value="<?php echo $action_type; ?>" />

			<?php if ( $action_type == 'schedule-subscription' ) { ?>

				<input type="hidden" name="schedule_only" value ="1" />

			<?php } else { ?>

				<input type="hidden" name="schedule_only" value ="0" />

			<?php } ?>

			<div class="pc-subscription-packages">

				<table class="subscription-table comparison-table">

					<thead>

						<!-- Subscription package name -->
						<tr>
							<?php if ( $action_type == 'new-subscription' ) { ?>

								<th class="comparison-table-header-main" rowspan="2"><?php _e( 'Subscribe Now', 'wpjobster' ); ?></th>

							<?php } elseif ( $action_type == 'upgrade-subscription' ) { ?>

								<th class="comparison-table-header-main" rowspan="2"><?php _e( 'Upgrade Now', 'wpjobster' ); ?></th>

							<?php } elseif ( $action_type == 'schedule-subscription' ) { ?>

								<th class="comparison-table-header-main" rowspan="2"><?php _e( 'Schedule Upgrade', 'wpjobster' ); ?></th>

							<?php }

							$subscription_index = 0;

							foreach ( $subscription_levels as $key => $value ) {

								if ( wpj_subscription_package_enabled( $key ) ) { ?>

									<th>

										<div class="subscr-name"><?php echo wpj_translate_string( $key ); ?></div>

										<!-- Subscription package price -->
										<div class="subscr-price level<?php echo $subscription_index; ?>">

											<?php if ( $action_type == 'upgrade-subscription' && $is_subscribed == 1 ) {
												$amount_chargeable = wpj_get_subscription_min_price_by_level( $subscription_index ) - $subscription_levels[$current_level][$current_type];

												if ( wpj_get_subscription_min_price_by_level( $subscription_index ) >= 1 ) {
													if ( $is_subscribed == 0 )
														$amount_chargeable = wpj_get_subscription_min_price_by_level( $subscription_index );
												}

											} else
												$amount_chargeable = wpj_get_subscription_min_price_by_level( $subscription_index );

											echo $amount_chargeable && $amount_chargeable > 0 ? wpj_show_price( $amount_chargeable ) : '-';

											$subscription_index++; ?>

										</div>
									</th>

								<?php }

							} ?>

						</tr>

					</thead>

					<tbody>

						<?php // Eligibility
						if ( $subscription_eligibility_enabled == 'yes' ) { ?>

							<tr>
								<td class="left-table-title">

									<?php _e( 'Minimum amount of sales', 'wpjobster' ); ?>

								</td>

								<?php for ( $eligibility_key = 0; $eligibility_key < $subscription_packages_number; $eligibility_key++ ) {

									if ( wpj_subscription_package_enabled( 'level' . $eligibility_key ) ) { ?>

										<td class="text-center">

											<?php echo $subscription_levels['level' . $eligibility_key]['eligility'] ? wpj_show_price( $subscription_levels['level' . $eligibility_key]['eligility'] ) : __( 'NA', 'wpjobster' ); ?>

										</td>

									<?php }

								} ?>

							</tr>

							<tr class="fw700">

								<td class="left-table-title">

									<?php echo sprintf( __( 'Current amount of sales: %s', 'wpjobster' ), wpj_show_price( $current_user_sales ) ); ?>

								</td>

								<?php for ( $eligibility_key = 0; $eligibility_key < $subscription_packages_number; $eligibility_key++ ) {

									if ( wpj_subscription_package_enabled( 'level' . $eligibility_key ) ) { ?>

										<td class="text-center">

											<?php if ( $subscription_levels['level' . $eligibility_key]['eligility'] ) {

												if ( wpj_number_format_special( $current_user_sales, 2 ) >= wpj_number_format_special( $subscription_levels['level' . $eligibility_key]['eligility'], 2 ) ) { ?>

													<span class="subscription-eligible"><?php _e( "ELIGIBLE", "wpjobster" ); ?></span>

												<?php } else { ?>

													<span class="subscription-not-eligible"><?php _e( "NOT ELIGIBLE", "wpjobster" ); ?></span>

												<?php }

											} ?>

										</td>

									<?php }

								} ?>

							</tr>

						<?php }

						// Features
						if ( $features ) {
							foreach ( $features as $f_key => $feature ) { $slug = $feature['slug']; ?>

								<tr>
									<td class="left-table-title"><?php echo $feature['label']; ?></td>

									<?php foreach ( $subscription_levels as $key => $subscr_value ) {

										if ( wpj_subscription_package_enabled( $key ) ) { ?>

											<td class="text-center">

												<?php $feature_value = $subscr_value[$slug];

												if ( $slug == 'tips' || $slug == 'job_packages' )
													echo $feature_value == 'yes' ? '<i class="checkmark icon"></i>' : '<i class="remove icon"></i>';

												elseif ( $slug == 'max_extra_price' || $slug == 'max_job_price' || $slug == 'max_ce_price' || $slug == 'min_extra_price' || $slug == 'min_job_price' || $slug == 'min_ce_price' )
													echo $feature_value ? wpj_show_price( $feature_value ) : '0';

												elseif ( $slug == 'fees' )
													echo $feature_value ? $feature_value . '%' : '-';

												elseif ( $slug == 'icon_url' )
													echo $feature_value ? '<img src="' . $feature_value . '" width="25" />' : '-';

												else
													echo $feature_value ? $feature_value : '-'; ?>

											</td>

										<?php }

									} ?>

								</tr>

							<?php }
						}

						// New features hook
						do_action( 'wpj_before_subscription_billing_period', $subscription_levels, '', 'pc' );

						if ( $pending_subscription ) { ?>

							<!-- Pending payment -->
							<tr>
								<td><?php _e( 'Pending payment', 'wpjobster' ); ?></td>

								<td colspan="4">
									<div class="float-left">
										<div class="ui mini buttons">
											<button class="ui negative button" onclick="event.preventDefault(); take_to_gateway_subscription_process( 'cancel', '<?php echo $pending_subscription->id; ?>', '<?php echo $pending_subscription->payment_gateway_name; ?>' )"><?php _e( 'Cancel', 'wpjobster' ); ?></button>

											<?php if ( $pending_subscription->payment_gateway_name != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $pending_subscription->payment_gateway_name ) ) { ?>

												<div class="or" data-text="<?php _e( 'or', 'wpjobster' ); ?>"></div>

												<button class="ui positive button" onclick="event.preventDefault(); take_to_gateway_subscription_process( 'process', '<?php echo $pending_subscription->id; ?>', '<?php echo $pending_subscription->payment_gateway_name; ?>' )"><?php _e( 'Process', 'wpjobster' ); ?></button>

											<?php } ?>

										</div>

										<div class="ui label"><?php _e( 'You already have a subscription whose payment is pending', 'wpjobster' ); ?></div>
									</div>
								</td>
							</tr>

						<?php } else { ?>

							<!-- Billing period -->
							<tr>
								<td><?php _e( 'Billing period', 'wpjobster' ); ?></td>

								<?php foreach ( $subscription_levels as $key => $subscr_value ) {

									if ( wpj_subscription_package_enabled( $key ) ) { ?>

										<td class="billing-period-row">

											<?php wpj_display_subscription_billing_period( 'pc', $subscription_levels , $key, $is_subscribed, $action_type, $current_level, $current_type ); ?>

										</td>

									<?php }

								} ?>

							</tr>

						<?php } ?>

					</tbody>

				</table>

			</div>

		</form>

	</div>

<?php }