<?php
/**
 * @var $uploader_purpose
 * @var $pid
 * @var $attachments
 * @var $wrapper_id
 * @var $wrapper_class
 */

if ( $uploader_purpose == 'job' && wpj_get_option( 'wpjobster_preferred_image_uploader' ) === 'html5fileupload' ) { // html5 ?>

	<div class="html5fileupload-wrapper images-uploader-wrapper" data-media-type="<?php echo $uploader_purpose; ?>">

		<div class="html5fileupload-images-wrapper cf images-wrapper" data-pid="<?php echo $pid; ?>">

			<?php if ( $attachments ) {

				foreach ( $attachments as $attachment ) { ?>

					<div class="file-wrapper pr" data-id="<?php echo $attachment->ID; ?>">

						<img alt="" width="90" class="no-border" height="90" src="<?php echo wpj_get_attachment_image_url( $attachment->ID, array( 90, 90 ) ); ?>" />

						<a data-attachment-id="<?php echo $attachment->ID; ?>" data-media-type="<?php echo $uploader_purpose; ?>" class="js-delete-file delete-file delete-image cursor-pointer"><i class="x icon"></i></a>

					</div>

				<?php }

			} ?>

		</div>

		<div class="html5fileupload-new-image-wrapper">

			<div class="html5fileupload job w100" data-max-filesize="<?php echo wpj_get_media_max_upload_size( $uploader_purpose ); ?>" data-remove-done="true" data-autostart="true" data-valid-mime="image.*" data-url="<?php echo get_template_directory_uri(); ?>/lib/uploaders/html5fileupload.php" data-multiple="true" data-pid="<?php echo $pid; ?>" data-uid="<?php echo $post->post_author; ?>">

				<input type="file" name="file" />

			</div>

		</div>

		<input type="hidden" name="images_order" id="images_order" />

	</div>

<?php } else { // dropzone ?>

	<div
		id="<?php echo $wrapper_id; ?>"
		class="dropzone images-uploader-wrapper <?php echo $wrapper_class; ?>-wrapper needsclick dz-clickable cf images-wrapper"
		data-pid="<?php echo $pid; ?>"
		data-maxnrofpictures="<?php echo wpj_get_media_max_upload_number( $uploader_purpose ); ?>"
		data-maxsize="<?php echo wpj_get_media_max_upload_size( $uploader_purpose ); ?>"
		data-media-type="<?php echo $uploader_purpose; ?>"
	>

		<?php if ( $attachments ) {

			foreach ( $attachments as $attachment ) { ?>

				<div class="dz-image-wrapper pr float-left" data-id="<?php echo $attachment->ID; ?>">

					<div class="dz-preview dz-image-preview dz-complete file-wrapper <?php if ( $uploader_purpose == 'job' && wpj_get_job_rejected_input( 'image' ) == 'rejected-input' ) echo 'mb-20'; ?>" data-id="<?php echo $attachment->ID; ?>" id="<?php echo $attachment->ID; ?>">

						<div class="dz-image">

							<?php if ( wpj_get_attachment_image_url( $attachment->ID, array( 110, 110 ) ) ) { ?>

								<img alt="" data-dz-thumbnail="" src="<?php echo wpj_get_attachment_image_url( $attachment->ID, array( 110, 110 ) ); ?>" />

							<?php } else { ?>

								<img alt="" data-dz-thumbnail="" src="<?php echo get_template_directory_uri() . '/assets/images/media/video-icon.svg'; ?>" />

							<?php } ?>

						</div>

						<a data-attachment-id="<?php echo $attachment->ID; ?>" data-media-type="<?php echo $uploader_purpose; ?>" class="js-delete-file delete-file delete-image cursor-pointer"><i class="x icon"></i></a>

					</div>

				</div>

			<?php }

		} ?>

	</div>

	<input type="hidden" id="images_order" name="images_order">

<?php }