<?php
/**
 * @var $cover_image_id
 * @var $cover_image_url
 * @var $cover_image_thumb
 * @var $pid
 */

if ( wpj_get_option( 'wpjobster_preferred_image_uploader' ) === 'html5fileupload' ) { // html5 ?>

	<div class="html5fileupload-wrapper cover-uploader-wrapper" data-media-type="cover">

		<?php if ( ! empty( $cover_image_id ) ) { ?>

			<div class="html5fileupload-images-wrapper cf cover-wrapper">

				<div class="file-wrapper pr">

					<img alt="" class="no-border" src="<?php echo $cover_image_url; ?>" />

					<a data-attachment-id="<?php echo $cover_image_id; ?>" data-media-type="cover" class="js-delete-file delete-file delete-image cursor-pointer"><i class="x icon"></i></a>

				</div>

			</div>

		<?php } ?>

		<div class="html5fileupload-new-image-wrapper">

			<div class="html5fileupload cover" data-max-filesize="<?php echo wpj_get_media_max_upload_size( 'cover' ); ?>" data-remove-done="true" data-autostart="true" data-valid-mime="image.*" data-url="<?php echo get_template_directory_uri(); ?>/lib/uploaders/html5fileupload.php" data-multiple="false" data-pid="<?php echo $pid; ?>" data-uid="<?php echo $post->post_author; ?>">

				<input type="file" name="file" />

			</div>

		</div>

	</div>

<?php } else { // dropzone ?>

	<div
		id="job_cover"
		class="dropzone cover-uploader-wrapper needsclick dz-clickable cf cursor-pointer"
		data-pid="<?php echo $pid; ?>"
		data-media-type="cover"
		data-maxnrofpictures="1"
		data-maxsize="<?php echo wpj_get_media_max_upload_size( 'cover' ); ?>"
	>

		<?php if ( is_numeric( $cover_image_id ) && $cover_image_thumb ) { ?>

			<div class="dz-image-wrapper">

				<div class="dz-preview dz-image-preview dz-complete file-wrapper" data-id="<?php echo $cover_image_id; ?>" id="<?php echo $cover_image_id; ?>">

					<div class="dz-image">

						<img alt="" data-dz-thumbnail="" src="<?php echo $cover_image_thumb; ?>">

					</div>

					<a data-attachment-id="<?php echo $cover_image_id; ?>" data-media-type="cover" class="js-delete-file delete-file delete-image cursor-pointer"><i class="x icon"></i></a>

				</div>

			</div>

		<?php } ?>

	</div>

<?php }