<?php
/**
 * @var $var
 * @var $pid
 * @var $action_type
 * @var $unique_slug
 * @var $rejected_title
 * @var $rejected_comment
 */

if ( $var || $action_type == "edit" ) {

	if ( $action_type == 'new' ) { ?>

		<div class="ui popup" data-tooltip-id="<?php echo $unique_slug; ?>"><?php echo $var; ?></div>

	<?php } elseif ( $action_type == 'edit' ) { ?>

		<div class="ui popup <?php echo ! empty( $rej_class ) ? $rej_class : ''; ?>" data-tooltip-id="<?php echo $unique_slug; ?>">

			<?php if ( get_post_status( $pid ) == 'pending' && $rejected_title == 1 ) {
				echo $rejected_comment;

			} else {

				if ( $var ) {
					echo $var;

				} else {
					_e( 'Regular users will not see this message unless you fill "Instructions" input of this field.', 'wpjobster' );

				}
			} ?>

		</div>

	<?php }

} elseif ( current_user_can( 'manage_options' ) ) { ?>

	<div class="ui popup" data-tooltip-id="<?php echo $unique_slug; ?>">

		<?php _e( 'Regular users will not see this message unless you fill "Instructions" input of this field.', 'wpjobster' ); ?>

	</div>

<?php }