<?php
/**
 * @var $uid
 * @var $response_rate
 * @var $delivered_on_time_percent
 * @var $completed_percent
 */
?>

<div class="user-info-sidebar-wrapper">

	<!-- User info -->
	<div class="user-info-simple-wrapper">

		<?php wpj_display_user_photo( array( 'uid' => $uid, 'width' => 75, 'height' => 75, 'border' => true, 'img_class' => 'user-info-avatar' ) ); ?>

		<div class="user-info-simple-content">
			<a class="user-name" href="<?php echo wpj_get_user_profile_link( $uid ); ?>">

				<?php echo apply_filters( 'wpj_user_account_sidebar_username_filter', wpj_get_user_display_type( $uid ), $uid ); ?>

			</a>
			<div class="user-stars"><?php wpj_display_user_rating_stars( $uid ); ?></div>
		</div>
	</div>

	<!-- User productivity -->
	<div class="user-productivity">

		<div class="order-response-rate row">
			<label><?php _e( 'Order response rate', 'wpjobster' ); ?></label>
			<div class="progress-wrapper">
				<div class="ui tiny progress" data-percent="<?php echo $response_rate; ?>">
					<div class="bar"></div>
				</div>
				<span class="progress-percent"><?php echo sprintf( __( '%d%%', 'wpjobster' ), $response_rate ); ?></span>
			</div>
		</div>

		<div class="average-response-time row">
			<label><?php _e( 'Average respone time', 'wpjobster' ); ?></label>
			<span class="average-value"><?php echo wpj_get_user_avg_response_time( $uid ); ?></span>
		</div>

		<?php if ( wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no' ) { ?>
			<div class="delivered-on-time row">
				<label><?php _e( 'Delivered on time', 'wpjobster' ); ?></label>
				<div class="progress-wrapper">
					<div class="ui tiny progress" data-percent="<?php echo $delivered_on_time_percent; ?>">
						<div class="bar"></div>
					</div>
					<span class="progress-percent"><?php echo sprintf( __( '%d%%', 'wpjobster' ), $delivered_on_time_percent ); ?></span>
				</div>
			</div>
		<?php } ?>

		<div class="order-completion row">
			<label><?php _e( 'Order completion', 'wpjobster' ); ?></label>
			<div class="progress-wrapper">
				<div class="ui tiny progress" data-percent="<?php echo $completed_percent; ?>">
					<div class="bar"></div>
				</div>
				<span class="progress-percent"><?php echo sprintf( __( '%d%%', 'wpjobster' ), $completed_percent ); ?></span>
			</div>
		</div>

	</div>

</div>