<!DOCTYPE html>

<html <?php language_attributes(); ?>>

	<?php do_action( 'wpj_before_head_tag_open' ); ?>

	<head>

		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

		<?php wp_head(); do_action( 'wpj_before_head_tag_close' ); ?>

	</head>

	<?php do_action( 'wpj_before_body_tag_open' ); ?>

	<body <?php body_class(); ?> >

<!-- SIDEBARS -->

		<div class="ui sidebar inverted vertical left menu">

			<?php if ( is_user_logged_in() ) {

				// Left menu
				wpj_display_dropdown_menu(
					[
						'menu'     => apply_filters( 'wpj_responsive_left_menu_loggedin_filter', wpj_get_menu_by_location( 'wpjobster_responsive_left_loggedin_menu' ) ),
						'language' => isset( $jobster_design['enable_language_left_menu_loggedin'] ) ? $jobster_design['enable_language_left_menu_loggedin'] : true,
						'currency' => isset( $jobster_design['enable_currency_left_menu_loggedin'] ) ? $jobster_design['enable_currency_left_menu_loggedin'] : true,
						'logout'   => isset( $jobster_design['enable_logout_left_menu_loggedin'] ) ? $jobster_design['enable_logout_left_menu_loggedin'] : true
					]
				);

			} else {

				// Left menu
				wpj_display_dropdown_menu(
					[
						'menu'     => apply_filters( 'wpj_responsive_left_menu_filter', wpj_get_menu_by_location( 'wpjobster_responsive_left_menu' ) ),
						'language' => isset( $jobster_design['enable_language_left_menu_not_loggedin'] ) ? $jobster_design['enable_language_left_menu_not_loggedin'] : true,
						'currency' => isset( $jobster_design['enable_currency_left_menu_not_loggedin'] ) ? $jobster_design['enable_currency_left_menu_not_loggedin'] : true,
						'logout'   => false
					]
				);

			} ?>

		</div><!-- END left sidebar -->

		<div class="ui sidebar vertical right inverted menu">

			<?php // Search form
			wpj_display_autosuggest_search_mobile();

			if ( is_user_logged_in() ) {

				// Right menu
				wpj_display_dropdown_menu(
					[
						'menu'     => apply_filters( 'wpj_responsive_right_menu_loggedin_filter', wpj_get_menu_by_location( 'wpjobster_responsive_right_loggedin_menu' ) ),
						'language' => isset( $jobster_design['enable_language_right_menu_loggedin'] ) ? $jobster_design['enable_language_right_menu_loggedin'] : false,
						'currency' => isset( $jobster_design['enable_currency_right_menu_loggedin'] ) ? $jobster_design['enable_currency_right_menu_loggedin'] : false,
						'logout'   => isset( $jobster_design['enable_logout_right_menu_loggedin'] ) ? $jobster_design['enable_logout_right_menu_loggedin'] : false
					]
				);

			} else {

				// Right menu
				wpj_display_dropdown_menu(
					[
						'menu'     => apply_filters( 'wpj_responsive_right_menu_filter', wpj_get_menu_by_location( 'wpjobster_responsive_right_menu' ) ),
						'language' => isset( $jobster_design['enable_language_right_menu_not_loggedin'] ) ? $jobster_design['enable_language_right_menu_not_loggedin'] : false,
						'currency' => isset( $jobster_design['enable_currency_right_menu_not_loggedin'] ) ? $jobster_design['enable_currency_right_menu_not_loggedin'] : false,
						'logout'   => false
					]
				);

			} ?>

		</div><!-- END right sidebar -->

<!-- END SIDEBARS -->

		<?php do_action( 'wpj_before_pusher' ); ?>

<!-- PAGE WRAPPER -->

		<!--[if IE ]><div class="<?php echo apply_filters( 'wpj_wrapper_class_filter', 'pusher ie autohide-keyboard' ); ?>"><![endif]-->
		<!--[if !IE]>-->
		<div id="page-wrap" class="<?php echo apply_filters( 'wpj_wrapper_class_filter', 'pusher autohide-keyboard' ); ?>">
		<!--<![endif]-->

			<?php if ( $no_header_footer == false ) { ?>

	<!-- PC HEADER -->

				<div class="header-wrapper mobile-hidden header-pc <?php if ( isset( $jobster_design['header_in_grid'] ) && $jobster_design['header_in_grid'] == false ) { echo 'header-wrapper-full'; } ?>">

					<!-- Top menu -->
					<div class="header-wrapper-top-holder">
						<div class="header-wrapper-top">

							<div class="main-content cf">

								<div class="header-language-and-currency">

									<?php /* Language selector */ wpj_display_languages_selector( 'pc' );

									/* Currency selector */ wpj_display_currency_selector( 'pc' ); ?>

								</div>

								<div class="logo-holder">
									<a href="<?php echo home_url( '/' ); ?>">
										<img alt="logo" class="logo logo-white" src="<?php echo wpj_get_site_white_logo_url(); ?>" />
										<img alt="logo" class="logo" src="<?php echo wpj_get_site_logo_url(); ?>" />
									</a>
								</div>

								<?php if (
									is_user_logged_in()
									|| ( ! is_user_logged_in() && ! is_front_page() )
									|| ! $different_front_page
								) {

									/* Search form */ wpj_display_autosuggest_search_with_button();

								}

								if ( ! is_user_logged_in() ) {

									/* Secondary menu */ wpj_display_secondary_menu( apply_filters( 'wpj_header_secondary_menu_filter', 'wpjobster_header_secondary_menu' ) );

								} ?>

								<div class="header-right-wrapper">

									<?php if ( is_user_logged_in() ) {

										/* Secondary menu */ wpj_display_secondary_menu( apply_filters( 'wpj_header_secondary_loggedin_menu_filter', 'wpjobster_header_secondary_loggedin_menu' ) );

										/* User notification icons */ wpj_display_notification_icons_menu();

										/* User info menu */ wpj_display_user_info_account_menu();

									} else {

										/* User authentication buttons */ wpj_display_authentication_buttons_menu( 'pc' );

									} ?>

								</div>

							</div>

						</div>
					</div>

					<!-- Categories menu -->
					<?php if (
						is_user_logged_in()
						|| ( is_front_page() && ! is_user_logged_in() && isset( $jobster_design['enable_categories_menu_not_loggedin_front_page'] ) && $jobster_design['enable_categories_menu_not_loggedin_front_page'] == true )
						|| ( ! is_front_page() && ! is_user_logged_in() && isset( $jobster_design['enable_categories_menu_not_loggedin'] ) && $jobster_design['enable_categories_menu_not_loggedin'] == true )
					) { ?>

						<div class="header-wrapper-menu-holder">
							<div class="header-wrapper-menu<?php if ( is_user_logged_in() || ( ! is_front_page() && ! empty( $jobster_design['header_middle_border'] ) && $jobster_design['header_middle_border'] == true ) || ( is_front_page() && ! empty( $jobster_design['header_middle_border_front'] ) && $jobster_design['header_middle_border_front'] == true )
								) { echo ' header-menu-border'; } ?>">

								<div class="main-content cf">

									<div class="main-menu-container<?php if ( ! empty( $jobster_design['enable_long_menu_arrows'] ) && $jobster_design['enable_long_menu_arrows'] == true ) { echo ' slider'; } ?>">

										<div class="main-menu-wrapper">

											<?php if ( ! empty( $jobster_design['enable_long_menu_arrows'] ) && $jobster_design['enable_long_menu_arrows'] == true ) { ?>

												<div class="arrows-wrapper">
													<a class="menu-direction-left float-left"><i class="angle left icon"></i></a>
													<a class="menu-direction-right float-right"><i class="angle right icon"></i></a>
												</div>

											<?php }

											wpj_display_main_menu(); ?>

										</div>

									</div>

								</div>

							</div>
						</div>

					<?php } ?>

				</div><!-- END header-pc -->

	<!-- END PC HEADER -->

	<!-- MOBILE HEADER -->

				<div class="header-wrapper computer-hidden header-mobile">

					<!-- Top menu -->
					<div class="header-wrapper-top-holder">
						<div class="header-wrapper-top">

							<div class="main-content cf">

								<div class="ui middle aligned grid">

									<div class="row<?php if ( is_user_logged_in() ) echo ' bordered-row'; ?>">

										<!-- User account menu icon -->
										<div class="four wide left aligned column">
											<a class="js-mobile-menu-toggle menu-left">

												<?php if ( $left_menu_image ) { ?>

													<img class="left-mobile-menu-image" src="<?php echo $left_menu_image; ?>" />

												<?php } else { ?>

													<i class="<?php echo $icon_menu_left; ?> icon fs32"></i>

												<?php } ?>

											</a>
										</div>

										<!-- Logo -->
										<div class="eight wide center aligned column">
											<div class="logo-holder">
												<a href="<?php echo home_url( '/' ); ?>">
													<img alt="logo" class="logo logo-white" src="<?php echo wpj_get_site_white_logo_url(); ?>" />
													<img alt="logo" class="logo" src="<?php echo wpj_get_site_logo_url(); ?>" />
												</a>
											</div>
										</div>

										<!-- Categories menu icon -->
										<div class="four wide right aligned column">
											<a class="js-mobile-menu-toggle menu-right">

												<?php if ( $right_menu_image ) { ?>

													<img class="right-mobile-menu-image" src="<?php echo $right_menu_image; ?>" />

												<?php } else { ?>

													<i class="<?php echo $icon_menu_right; ?> icon fs32"></i>

												<?php } ?>

											</a>
										</div>

									</div>

								</div>

							</div>

						</div>
					</div>

					<!-- User account -->
					<?php if ( is_user_logged_in() ) { ?>

						<div class="header-wrapper-menu-holder">
							<div class="header-wrapper-menu">

								<div class="main-content cf">

									<div class="ui middle aligned grid">

										<div class="eight wide column">

											<?php /* User notification icons */ wpj_display_notification_icons_menu(); ?>

										</div>

										<div class="eight wide column">

											<?php /* User info menu */ wpj_display_user_info_account_menu(); ?>

										</div>

									</div>

								</div>

							</div>
						</div>

					<?php } ?>

				</div><!-- END header-mobile -->

	<!-- END MOBILE HEADER -->

			<?php } ?>

	<!-- PAGE CONTENT -->
			<div id="main-wrapper">
				<div class="<?php echo ! empty( $post->post_name ) ? $post->post_name : ''; ?>-page main-content cf" id="main-content">

					<?php wpj_init_authentication_modals(); // Init authentication modals