<?php

/* Table header */
$table_header = array(
	__( 'Job Details'  , 'wpjobster' ) => 'eight',
	__( 'Delivery Time', 'wpjobster' ) => 'three',
	__( 'Job Price'    , 'wpjobster' ) => 'three',
	__( 'Remove'       , 'wpjobster' ) => 'two'
);

/* Job info */
ob_start(); ?>

<div class="df flex-thumb-text">

	<div class="service-avatar-wrapper">

		<a href="<?php echo get_permalink( $pid ); ?>" class="upb_bookmark_link" title="<?php echo get_the_title( $pid ); ?>" class="service-avatar">

			<img width="50" height="50" class="round-avatar" src="<?php echo wpj_get_job_image( $pid, 61, 61 ); ?>" />

		</a>

	</div>

	<div>
		<h4 class="service-title">

			<a href="<?php echo get_permalink( $pid ); ?>" class="upb_bookmark_link" title="<?php echo get_the_title( $pid ); ?>">

				<?php echo get_the_title( $pid ); ?>

			</a>

		</h4>

		<?php wpj_display_job_rating_stars( $pid ); wpj_display_job_reviews_number( $pid ); ?>

	</div>

</div>

<?php $job_info = ob_get_contents(); ob_end_clean();

/* Job price */
if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' && $package_price ) {
    $price = wpj_show_price(min($package_price)) . ' - ' . wpj_show_price(max($package_price));

} else {
	if ( get_post_meta( $pid, 'price', true ) > 0 ) {
        $price = wpj_show_price( get_post_meta( $pid, 'price', true ), 1 );

    } else {
		if ( wpj_bool_option( 'wpjobster_replace_zero_with_free' ) )
            $price = __( 'Free', 'wpjobster' );
		else
            $price = wpj_show_price( get_post_meta( $pid, 'price', true ), 1 );

	}
}

/* Favorites */
ob_start(); ?>

<div class="job-favorites">

	<?php if ( $jobster_design['favorites_slider_icon_options_job'] )
		wpj_display_job_favorite_icon( $pid, '<i class="' . $jobster_design['favorites_slider_icon_options_job'] . ' red icon"></i>', '<i class="' . $jobster_design['favorites_slider_icon_options_job'] . ' outline grey icon"></i>' );

	else
		wpj_display_job_favorite_icon( $pid, '<i class="heart red icon"></i>', '<i class="heart outline grey icon"></i>' ); ?>

</div>

<?php $job_favorites = ob_get_contents(); ob_end_clean();

/* Table body */
$table_content = array(
	$job_info,
	get_post_meta( $pid, "max_days", true ) . ' ' . _n( "day", "days", get_post_meta( $pid, "max_days", true ), "wpjobster" ),
	$price,
	$job_favorites
);

/* Display table */
wpj_display_table( 'upb_bookmark bookmark-' . $pid, $table_header, $table_content );