<?php

/* Table header */
$table_header = array(
	__( 'Job Details', 'wpjobster' ) => 'seven',
	__( 'Date'       , 'wpjobster' ) => 'three',
	__( 'Price'      , 'wpjobster' ) => 'four',
	__( 'Status'     , 'wpjobster' ) => 'two'
);

/* Job details */
ob_start(); ?>

<div class="df flex-thumb-text">

	<!-- Job image -->
	<div class="service-avatar-wrapper">
		<a href="<?php the_permalink(); ?>" class="service-avatar">
			<img width="50" height="50" class="round-avatar" src="<?php echo wpj_get_job_image( $pid, 60, 60 ); ?>" />
		</a>
	</div>

	<div>

		<!-- Job title -->
		<h4 class="service-title"><a href="<?php the_permalink(); ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php echo get_the_title( $pid ); ?></a></h4>

		<ul class="service-action-buttons">

			<!-- Feature button -->
			<?php if ( wpj_get_option( 'wpjobster_featured_enable' ) == 'yes' ) { ?>

				<li>
					<a class="text-button text-button-small text-button-highlighted" href="<?php echo get_permalink( wpj_get_option( 'wpjobster_feature_page_id' ) ) . get_post( $pid )->post_name; ?>"><?php echo $g == 0 ? __( 'Featured', 'wpjobster' ) : __( 'Feature', 'wpjobster' ); ?></a>
				</li>

			<?php } ?>

			<!-- Edit button -->
			<li>
				<a class="text-button text-button-small text-button-gray" href="<?php echo add_query_arg( array( 'jobid' => $pid, 'action' => 'edit-job' ), get_permalink( wpj_get_option( 'wpjobster_post_new_page_id' ) ) ); ?>" class="edit_job"><?php _e( 'Edit', 'wpjobster' ); ?></a>
			</li>

			<!-- Activate/Deactivate button -->
			<li>
				<a class="text-button text-button-small text-button-gray <?php echo $btn_class; ?>" data-id="<?php echo $pid; ?>" data-title="<?php the_title(); ?>"><?php echo get_post_meta( $pid, 'active', true ) == '1' ? __( 'Deactivate', 'wpjobster' ) : __( 'Activate', 'wpjobster' ); ?></a>
			</li>

			<!-- Delete button -->
			<li>
				<a class="text-button text-button-small text-button-dangerous-soft js-delete-job-link" data-id="<?php echo $pid; ?>" data-title-delete="<?php the_title(); ?>"><?php _e( 'Delete', 'wpjobster' ); ?></a>
			</li>

		</ul>

		<!-- Pending review info -->
		<?php if ( $post->post_status == "pending" ) { ?>

			<span class="under-review-warning"><?php _e( 'Please edit the job following the provided instructions.', 'wpjobster' ); ?></span>

		<?php } ?>

	</div>

</div>

<?php $job_details = ob_get_contents(); ob_end_clean();

/* Job price */
if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && get_post_meta( $pid, 'job_packages', true ) == 'yes' && $package_price )
	$price = '<div class="service-price">' . wpj_show_price( min( $package_price ) ) . ' - ' . wpj_show_price( max( $package_price ) ) . '</div>';

else {
	if ( get_post_meta( $pid, 'price_type', true ) ) {
		$price = '<div class="service-price">';
		$price .= wpj_show_price( get_post_meta( $pid, 'price', true ), 1 );
		$price .= '
			<span class="small-job">(' . apply_filters( 'wpj_price_type_filter', sprintf( __( '%s rate', 'wpjobster' ), wpj_translate_string( get_post_meta( $pid, 'price_type', true ) ) ), $pid ) . ')</span>
		';
		$price .= '</div>';

	} elseif ( get_post_meta( $pid, 'price', true ) > 0 )
		$price = '<div class="service-price">' . wpj_show_price( get_post_meta( $pid, 'price', true ), 1 ) . '</div>';

	else {
		if ( wpj_bool_option( 'wpjobster_replace_zero_with_free' ) ) $price = __( 'Free','wpjobster' );
		else $price = '<div class="service-price">' . wpj_show_price( get_post_meta( $pid, 'price', true ), 1 );
	}
}

/* Table body */
$table_content = array(
	$job_details,
	get_the_date( wpj_get_option( 'date_format' ), $pid ),
	$price,
	'<div class="my-account-service-status"><span class="oe-status-btn ' . $class . '">' . $text . '</span></div>'
);

/* Display table */
wpj_display_table( 'js-user-job-item' . $pid, $table_header, $table_content );