<!-- pm container -->
<div id="pm_<?php echo $row->id; ?>" class="js-pm-holder pm-holder cf pm-sent <?php echo $bgcolor . ' ' . $custom_offer_class . ' ' . $title_icon . ( $user1 == $row->initiator ? ' pm-user-own-message' : '' ); ?>">

	<!-- message user avatar -->
	<div class="pm-avatar" data-tooltip="<?php echo wpj_get_user_display_type( $initiator_data->ID ); ?>" data-position="<?php echo $user1 == $row->initiator ? 'top right' : 'top left'; ?>" data-inverted="">

		<?php wpj_display_user_photo( ['uid' => $row->initiator, 'width' => 45, 'height' => 45, 'with_level_image' => false] ); ?>

	</div>

	<!-- message content -->
	<div class="pm-content-holder">
		
		<!-- custom offer -->
		<?php if ( $row->custom_offer == -1 ) { ?>

			<div class="pm-custom-offer">

				<div class="pm-custom-offer-header-wrapper">

					<!-- custom offer request -->
					<div class="pm-custom-offer-header-title">

						<?php if ( $user1 == $row->initiator ) _e( "Custom Offer Request Sent", "wpjobster" );
						elseif ( $user1 == $row->user ) _e( "Custom Offer Request Received", "wpjobster" ); ?>

					</div>

					<?php if ( ( $user1 == $row->initiator || $row->user ) && get_the_title( $custom_offer_id ) ) { ?>

						<a href="<?php echo get_permalink( $custom_offer_id ); ?>" class="pm-custom-offer-header-subtitle"><?php echo get_the_title( $custom_offer_id ) ? trim( get_the_title( $custom_offer_id ) ) : $custom_offer_id; ?></a>

					<?php } ?>

				</div>

				<div class="pm-custom-offer-body">

					<div class="pm-custom-offer-content-wrapper">

						<div class="pm-custom-offer-content-message">

							<?php do_action( 'wpj_before_message_content', $row->id, $custom_offer_type, 'private_messages' );

							if ( $post_id ) { ?>

								<div class="ui horizontal label">

									<a href="<?php echo get_permalink( $post_id ); ?>"><?php echo get_the_title( $post_id ); ?></a>

								</div>

							<?php }

							echo wpj_make_links_clickable( $message ); ?>

							<?php // message attachments
							if ( wpj_post_has_attachments ( $row->attached ) )
							wpj_display_attachments_list( $row->attached, '', '', true, __( 'Attachments', 'wpjobster' ), true, false ); ?>

						</div>

						<div class="pm-settings">

							<div class="ui floating right pointing dropdown">

								<i class="cog icon"></i>

								<div class="menu">

									<?php do_action( 'wpj_before_message_action_buttons', $row->id, $row->content ); ?>

									<!-- Delete -->
									<div class="item js-pm-delete" data-pm-id="<?php echo $row->id; ?>">
										<i class="trash icon"></i>
										<?php _e( 'Delete', 'wpjobster' ); ?>
									</div>

								</div>

							</div>

						</div>

					</div>

					<div class="separator-15px"></div>

					<?php // Create custom offer
					if ( $user1 == $row->user && $user2_slug ) { ?>

						<div class="pm-custom-offer-actions">

							<?php wpj_display_custom_offer_button( [
								'unique_id'       => 'pm_send_' . $row->id,
								'id'              => $pid,
								'title'           => __( 'Create Custom Offer', 'wpjobster' ),
								'offer_type'      => 'send',
								'current_user_id' => $user1,
								'post_author_id'  => $row->initiator,
								'page'            => 'private_messages'
							] ); ?>

						</div>

					<?php } ?>
						
				</div>

			</div>

		<?php } elseif ( $row->custom_offer > 0 ) { ?>

			<div class="pm-custom-offer">

				<div class="pm-custom-offer-header-wrapper">

					<!-- custom offer sent -->
					<div class="pm-custom-offer-header-title">

						<?php if ( $user1 == $row->initiator ) _e( "Custom Price Offer Sent", "wpjobster" );
						elseif ( $user1 == $row->user ) _e( "Custom Price Offer Received", "wpjobster" ); ?>

					</div>

					<?php if ( ( $user1 == $row->initiator || $row->user ) && get_the_title( $custom_offer_id ) ) { ?>
						<a href="<?php echo get_permalink( $custom_offer_id ); ?>" class="pm-custom-offer-header-subtitle"><?php echo get_the_title( $custom_offer_id ) ? trim( get_the_title( $custom_offer_id ) ) : $custom_offer_id; ?></a>
					<?php } ?>

				</div>

				<div class="pm-custom-offer-body">

					<!-- custom offer message details -->
					<?php if ( $pm_custom_offer_price_filter || $pm_custom_offer_duration_filter ) { ?>

						<div class="meta-columns-wrapper">

							<?php if ( $pm_custom_offer_price_filter ) { ?>

								<div class="meta-column">

									<div class="label-class"><?php _e( "Price", "wpjobster" ) . ':'; ?></div>

									<div class="value-class"><?php echo wpj_show_price_classic( get_post_meta( $row->custom_offer, "price", true ), 1 ); ?></div>

								</div>

							<?php } ?>

							<?php if ( $pm_custom_offer_duration_filter ) { ?>

								<div class="meta-column">

									<div class="label-class"><?php _e( "Duration", "wpjobster" ) . ':'; ?></div>

									<div class="value-class"><?php echo $delivery_days . ' ' . $days_word; ?></div>

								</div>

							<?php } ?>

						</div>

					<?php } ?>

					<div class="pm-custom-offer-content-wrapper">

						<div class="pm-custom-offer-content-message">

							<?php do_action( 'wpj_before_message_content', $row->id, $custom_offer_type, 'private_messages' );

							if ( $post_id ) { ?>

								<div class="ui horizontal label">

									<a href="<?php echo get_permalink( $post_id ); ?>"><?php echo get_the_title( $post_id ); ?></a>

								</div>

							<?php }

							echo wpj_make_links_clickable( $message ); ?>

							<?php // message attachments
							if ( wpj_post_has_attachments ( $row->attached ) )
							wpj_display_attachments_list( $row->attached, '', '', true, __( 'Attachments', 'wpjobster' ), true, false ); ?>

						</div>

						<div class="pm-settings">

							<div class="ui floating right pointing dropdown ">

								<i class="cog icon"></i>

								<div class="menu">

									<?php do_action( 'wpj_before_message_action_buttons', $row->id, $row->content ); ?>

									<!-- Delete -->
									<div class="item js-pm-delete" data-pm-id="<?php echo $row->id; ?>">
										<i class="trash icon"></i>
										<?php _e( 'Delete', 'wpjobster' ); ?>
									</div>

								</div>

							</div>

						</div>

					</div>

					<!-- custom offer message response -->
					<div class="pm-custom-offer-actions">

						<div class="btn-margin-bottom-helper">

							<?php if ( $user1 == $row->initiator ) {

								if ( get_post_meta( $row->custom_offer, "offer_accepted", true ) == 1 ) { ?>

									<span class="color-20c497"> <?php _e( "Your offer was accepted!", "wpjobster" ); ?></span>

								<?php } elseif ( get_post_meta($row->custom_offer, "offer_declined", true ) == 1 ) { ?>

									<span class="color-ff6252"><?php _e( "Your offer was declined.", "wpjobster" ); ?></span>

								<?php } elseif ( get_post_meta($row->custom_offer, "offer_withdrawn", true ) == 1 ) { ?>

									<span class="color-ff6252"><?php _e( "You have withdrawn your offer.", "wpjobster" ); ?></span>

								<?php } elseif ( get_post_meta($row->custom_offer, "offer_expired", true ) == 1 ) { ?>

									<span class="color-ff6252"><?php _e( "Your offer expired.", "wpjobster" ); ?></span>

								<?php } else { // withdraw custom offer ?>

									<div class="actions">

										<a data-id="<?php echo $row->id; ?>" data-custom-offer="<?php echo $row->custom_offer; ?>" class="js-withdraw-custom-offer custom-offer-pm text-button text-button-gray2">

											<?php _e( "Withdraw Custom Offer", "wpjobster" ); ?>

										</a>

									</div>

								<?php }

							} elseif ( $user1 == $row->user ) {

								if ( get_post_meta( $row->custom_offer, "offer_accepted", true ) == 1 ) { ?>

									<span class="color-20c497"><?php _e( "Your have accepted the offer!", "wpjobster" ); ?></span>

								<?php } elseif ( get_post_meta( $row->custom_offer, "offer_declined", true ) == 1 ) { ?>

									<span class="color-ff6252"><?php _e( "You have declined the offer.", "wpjobster" ); ?></span>

								<?php } elseif ( get_post_meta( $row->custom_offer, "offer_withdrawn", true ) == 1 ) { ?>

									<span class="color-ff6252"><?php _e( "The offer was withdrawn by the seller.", "wpjobster" ); ?></span>

								<?php } elseif ( get_post_meta( $row->custom_offer, "offer_expired", true ) == 1 ) { ?>

									<span class="color-ff6252"><?php _e( "The offer expired.", "wpjobster" ); ?></span>

								<?php } else { // accept custom offer ?>

									<div class="actions">

										<form method="post" class="dib" name="purchase<?php echo $row->custom_offer; ?>" action="<?php echo get_permalink( wpj_get_option( 'wpjobster_checkout_page_id' ) ); ?>">

											<button data-id="<?php echo $row->id; ?>" data-custom-offer="<?php echo $row->custom_offer; ?>" type="submit" class="custom-offer-pm text-button text-button-confirmation">
												<?php _e( "Accept Custom Offer", "wpjobster" ); ?>

												<?php echo '&nbsp;-&nbsp;&nbsp;'; ?>

												<strong class="total" data-price="<?php echo wpj_number_format_special_exchange( $prc ); ?>" data-cur="<?php echo wpj_get_site_currency(); ?>">

													<?php echo wpj_show_price( $prc ); ?>

												</strong>
											</button>

											<input type="hidden" name="jobid" value="<?php echo $row->custom_offer; ?>" />
											<input type="hidden" name="purchaseformvalidation" value="ok" />

										</form>

										<span>

											<!-- decline custom offer -->
											<a data-id="<?php echo $row->id; ?>" data-custom-offer="<?php echo $row->custom_offer; ?>" class="js-decline-custom-offer custom-offer-pm text-button text-button-dangerous-soft">

												<?php _e( "Decline Custom Offer", "wpjobster" ); ?>

											</a>

										</span>

									</div>

								<?php }
							} ?>

						</div>

					</div>

				</div>

			</div>

		<?php } else { ?>

			<div class="pm-content">

				<div class="pm-content-inner">

					<?php if ( ! isset( $initiator_data->user_login ) ) { ?>

						<div class="df pm-content-header">

							<div class="pm-user">

								<h4><?php _e( "Deleted User", "wpjobster" ); ?></h4>

							</div>

						</div>

					<?php } ?>

					<!-- filtered message + errors -->
					<div class="pm-content-message">

						<?php do_action( 'wpj_before_message_content', $row->id, $custom_offer_type, 'private_messages' );

						if ( $post_id ) { ?>

							<div class="ui horizontal label">

								<a href="<?php echo get_permalink( $post_id ); ?>"><?php echo get_the_title( $post_id ); ?></a>

							</div>

						<?php }

						echo wpj_make_links_clickable( $message ); ?>

					</div>

					<?php // message attachments
					if ( wpj_post_has_attachments ( $row->attached ) )
					wpj_display_attachments_list( $row->attached, '', '', true, __( 'Attachments', 'wpjobster' ), true, false );

					// message image attachments
					if ( wpj_post_has_attachments ( $row->more_details ) )
					wpj_display_attachments_list( $row->more_details, '', 'image_attachments', false, '', true, false ); ?>

				</div>

				<!-- message settings -->
				<div class="pm-settings">

					<div class="ui floating right pointing dropdown ">

						<i class="cog icon"></i>

						<div class="menu">

							<?php do_action( 'wpj_before_message_action_buttons', $row->id, $row->content ); ?>

							<!-- Delete -->
							<div class="item js-pm-delete" data-pm-id="<?php echo $row->id; ?>">
								<i class="trash icon"></i>
								<?php _e( 'Delete', 'wpjobster' ); ?>
							</div>

						</div>

					</div>

				</div>

			</div>

		<?php } ?>

		<div class="pm-date"><?php echo wpj_date( wpj_time_or_date_format( $row->datemade ), $row->datemade ); ?></div>

	</div>

</div>