<?php

/* Table header */
$table_header = array(
	__( 'Job'           , 'wpjobster' ) => 'three',
	__( 'Buyer'         , 'wpjobster' ) => 'two',
	__( 'Date Purchased', 'wpjobster' ) => 'three',
	__( 'Date Completed', 'wpjobster' ) => 'three',
	__( 'Date Clearing' , 'wpjobster' ) => 'three',
	__( 'Amount'        , 'wpjobster' ) => 'two',
);

/* Table body */
$table_content = array(
	'<a href="' . wpj_get_order_link( $row->id ) . '">' . $real_post_title . ' (#' . $transaction_id . ')</a>',
	'<a href="' . wpj_get_user_profile_link( $row->uid ) . '">' . wpj_get_user_display_type( $row->uid ) . '</a>',
	wpj_date( wpj_get_option( 'date_format' ), $row->date_made ),
	$row->date_completed ? wpj_date( wpj_get_option( 'date_format' ), $row->date_completed ) : '-',
	$row->date_to_clear ? wpj_date( wpj_get_option( 'date_format' ), $row->date_to_clear ) : '-',
	wpj_show_price_classic( $total_amount_minus_fee )
);

/* Display table */
wpj_display_table( '', $table_header, $table_content );