<?php

/* Table header */
$table_header = array(
	__( 'Order'          , 'wpjobster' ) => 'two',
	__( 'Date'           , 'wpjobster' ) => 'four',
	__( 'Amount'         , 'wpjobster' ) => 'two',
	__( 'Type of payment', 'wpjobster' ) => 'three',
	__( 'Status'         , 'wpjobster' ) => 'two',
	__( 'Action'         , 'wpjobster' ) => 'three',
);

ob_start(); wpj_display_topup_camouflaged_order( $row->id ); $order_details = ob_get_contents(); ob_end_clean();

ob_start(); ?>

<div class="ui mini buttons">

	<button class="ui negative button" onclick="take_to_gateway_topup_process( 'cancel', '<?php echo $row->id; ?>', '<?php echo $row->payment_gateway_name; ?>', '<?php echo $row->package_id; ?>' )">

		<?php _e( 'Cancel', 'wpjobster' ); ?>

	</button>

	<?php if ( $row->payment_gateway_name != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $row->payment_gateway_name ) ) { ?>

		<div class="or" data-text="<?php _e( 'or', 'wpjobster' ); ?>"></div>

		<button class="ui positive button" onclick="take_to_gateway_topup_process( 'process', '<?php echo $row->id; ?>', '<?php echo $row->payment_gateway_name; ?>', '<?php echo $row->package_id; ?>' )">

			<?php _e( 'Process', 'wpjobster' ); ?>

		</button>

	<?php } ?>

</div>

<?php $action = ob_get_contents(); ob_end_clean();

/* Table body */
$table_content = array(
	$order_details,
	wpj_date( wpj_get_option( 'date_format' ) . ' - ' . wpj_get_option( 'time_format' ), $row->added_on ),
	wpj_show_price_classic( $row->package_amount ),
	wpj_translate_string( $row->payment_gateway_name ),
	wpj_translate_string( $row->payment_status ),
	$action,
);

/* Display table */
wpj_display_table( '', $table_header, $table_content );