<?php

/* Table header */
$table_header = apply_filters( 'wpj_sales_table_header_filter', array(
	__( 'Order Details', 'wpjobster' ) => 'five',
	__( 'Buyer'        , 'wpjobster' ) => 'three',
	__( 'Sold On'      , 'wpjobster' ) => 'two',
	__( 'Delivery'     , 'wpjobster' ) => 'two',
	__( 'Total'        , 'wpjobster' ) => 'two',
	__( 'Status'       , 'wpjobster' ) => 'two'
) );

/* Order info */
ob_start(); ?>

<div class="df flex-thumb-text">

	<div class="service-avatar-wrapper">

		<a href="<?php echo wpj_get_order_link( $row->id ); ?>" rel="<?php echo $row->id; ?>" title="" class="service-avatar">

			<img width="50" height="50" class="round-avatar" src="<?php echo wpj_is_custom_offer( $pid ) ? get_template_directory_uri() . '/assets/images/payment/custom-offer-thumbnail.png' : $job_image_url; ?>" />

		</a>

	</div>

	<div class="y-center-x-left">

		<h4 class="service-title">

			<a href="<?php echo wpj_get_order_link( $row->id ); ?>" rel="<?php echo $row->id; ?>" title="">

				<?php echo $this_post_title; ?>

			</a>

		</h4>

		<?php if ( $row->job_type ) { ?>

			<div class="ui tiny label"><?php echo wpj_translate_string( $row->job_type ); ?></div>

		<?php } ?>

	</div>

</div>

<?php $job_info = ob_get_contents(); ob_end_clean();

/* Order price */
if ( $total_amount > 0 ) $price = wpj_show_price_classic( $total_amount, 1 );
else {
	if ( wpj_bool_option( 'wpjobster_replace_zero_with_free' ) ) $price = __( 'Free', 'wpjobster' );
	else $price = wpj_show_price_classic( ( $row->mc_gross + $row->processing_fees + $row->tax_amount ), 1 );
}

/* Table body */
$table_content = apply_filters( 'wpj_sales_table_content_filter', array(
	$job_info,
	'<a href="' . wpj_get_user_profile_link( $row->uid ) . '">' . wpj_get_user_display_type( $row->uid ) . '</a>',
	wpj_date( wpj_get_option( 'date_format' ), $row->date_made ),
	apply_filters( 'wpj_sales_delivery_filter', wpj_date( wpj_get_option( 'date_format' ), wpj_get_expected_delivery( $row->id ) ), $row->id ),
	$price,
	'<div class="my-account-service-status"><span class="oe-status-btn ' . $class . '">' . $text . '</span></div>'
), $row );

/* Display table */
wpj_display_table( '', $table_header, $table_content );