<?php

/* Table header */
$table_header = apply_filters( 'wpj_shopping_table_header_filter', array(
	__( 'Order Details', 'wpjobster' ) => 'five',
	__( 'Seller'       , 'wpjobster' ) => 'three',
	__( 'Purchased On' , 'wpjobster' ) => 'two',
	__( 'Delivery'     , 'wpjobster' ) => 'two',
	__( 'Total'        , 'wpjobster' ) => 'two',
	__( 'Status'       , 'wpjobster' ) => 'two'
) );

/* Order info */
ob_start(); ?>

<div class="df flex-thumb-text">

	<div class="service-avatar-wrapper">

		<a href="<?php echo wpj_get_order_link( $row->id ); ?>" rel="<?php echo $row->id; ?>" title="" class="service-avatar">

			<img width="60" height="60" class="round-avatar" src="<?php echo wpj_is_custom_offer( $pid ) ? get_template_directory_uri() . '/assets/images/payment/custom-offer-thumbnail.png' : $job_image_url; ?>" />

		</a>

	</div>

	<div class="y-center-x-left">

		<h4 class="service-title">

			<a href="<?php echo wpj_get_order_link( $row->id ); ?>" rel="<?php echo $row->id; ?>" title="">

				<?php echo $this_post_title; ?>

			</a>

		</h4>

		<div class="service-action-buttons">

			<?php if ( $row->payment_status == 'pending' ) {

				if ( isset( $post->post_status ) && $post->post_status == 'publish' ) { ?>

					<a class="text-button text-button-small text-button-gray" onclick='take_to_gateway_job_purchase_process( "cancel", "<?php echo $row->id; ?>", "<?php echo $row->payment_gateway; ?>" )'><?php _e( 'Cancel', 'wpjobster' ); ?></a>

					<?php if ( $row->payment_gateway != 'banktransfer' && apply_filters( 'wpj_show_process_link_order_page_filter', true, $row->payment_gateway ) ) { ?>

						<a class="text-button text-button-small" onclick='take_to_gateway_job_purchase_process( "process", "<?php echo $row->id; ?>", "<?php echo $row->payment_gateway; ?>" )'><?php _e( 'Process', 'wpjobster' ); ?></a>

					<?php }

				} else { ?>

					<a class="ui tiny label"><?php _e( 'This job is not available anymore', 'wpjobster' ); ?></a>

				<?php }

			}

			if ( $row->job_type ) { ?>

				<div class="ui tiny label"><?php echo wpj_translate_string( $row->job_type ); ?></div>

			<?php } ?>

		</div>

	</div>

</div>

<?php $job_info = ob_get_contents(); ob_end_clean();

/* Order price */
if ( $total_amount > 0 ) $price = wpj_show_price_classic( $total_amount, 1 );
else {
	if ( wpj_bool_option( 'wpjobster_replace_zero_with_free' ) ) $price = __( 'Free', 'wpjobster' );
	else $price = wpj_show_price_classic( ( $row->mc_gross + $row->processing_fees + $row->tax_amount ), 1 );
}

/* Table body */
$table_content = apply_filters( 'wpj_shopping_table_content_filter', array(
	$job_info,
	'<a href="' . wpj_get_user_profile_link( $post->post_author ) . '">' . wpj_get_user_display_type( $post->post_author ) . '</a>',
	wpj_date( wpj_get_option( 'date_format' ), $row->date_made ),
	apply_filters( 'wpj_shopping_delivery_filter', wpj_date( wpj_get_option( 'date_format' ), wpj_get_expected_delivery( $row->id ) ), $row->id ),
	$price,
	'<div class="my-account-service-status"><span class="oe-status-btn ' . $class . '">' . $text . '</span></div>'
), $row );

/* Display table */
wpj_display_table( '', $table_header, $table_content );