<?php

/* Table header */
$table_header = array(
	__( 'Title'        , 'wpjobster' ) => 'six',
	__( 'Price'        , 'wpjobster' ) => 'two',
	__( 'Delivery Days', 'wpjobster' ) => 'two',
	__( 'Action'       , 'wpjobster' ) => 'four',
	__( 'Subject'      , 'wpjobster' ) => 'two'
);

/* Action */
ob_start();

if ( $active_tab == 'send' ) {

	if ( $accepted == 1 ) { ?>

		<span class="color-20c497"> <?php _e( "Your offer was accepted!", "wpjobster" ); ?></span>

	<?php } elseif ( $declined == 1 ) { ?>

		<span class="color-ff6252"><?php _e( "Your offer was declined.", "wpjobster" ); ?></span>

	<?php } elseif ( $withdrawn == 1 ) { ?>

		<span class="color-ff6252"><?php _e( "You have withdrawn your offer.", "wpjobster" ); ?></span>

	<?php } elseif ( $expired == 1 ) { ?>

		<span class="color-ff6252"><?php _e( "Your offer expired.", "wpjobster" ); ?></span>

	<?php } else { ?>

		<a data-id="<?php echo $row->id; ?>" data-custom-offer="<?php echo $row->custom_offer; ?>" class="text-button text-button-medium cursor-pointer js-withdraw-custom-offer">

			<?php _e( "Withdraw", "wpjobster" ); ?>

		</a>

	<?php }

} elseif ( $active_tab == 'received' ) {

	if ( $accepted == 1 ) { ?>

		<span class="color-20c497"><?php _e( "Your have accepted the offer!", "wpjobster" ); ?></span>

	<?php } elseif ( $declined == 1 ) { ?>

		<span class="color-ff6252"><?php _e( "You have declined the offer.", "wpjobster" ); ?></span>

	<?php } elseif ( $withdrawn == 1 ) { ?>

		<span class="color-ff6252"><?php _e( "The offer was withdrawn by the seller.", "wpjobster" ); ?></span>

	<?php } elseif ( $expired == 1 ) { ?>

		<span class="color-ff6252"><?php _e( "The offer expired.", "wpjobster" ); ?></span>

	<?php } else { ?>

		<div class="ui mini buttons">

			<form class="di" method="post" id="purchase<?php echo $row->custom_offer; ?>" name="purchase<?php echo $row->custom_offer; ?>" action="<?php echo get_permalink( wpj_get_option( 'wpjobster_checkout_page_id' ) ); ?>">

				<a href='javascript:void(0)' class="ui green button" data-id="<?php echo $row->id; ?>" onclick="document.getElementById( 'purchase<?php echo $row->custom_offer; ?>' ).submit(); return false;"><?php _e( "Accept", "wpjobster" ); ?></a>

				<input type="hidden" name="purchaseformvalidation" value="ok" />
				<input type="hidden" name="jobid" value="<?php echo $pid; ?>" />

			</form>

			<div data-text="<?php _e( 'or', 'wpjobster' ); ?>" class="or"></div>

			<a data-id="<?php echo $row->id; ?>" data-custom-offer="<?php echo $row->custom_offer; ?>" class="ui red button js-decline-custom-offer"><?php _e( "Decline", "wpjobster" ); ?></a>

		</div>

	<?php }

}

$action = ob_get_contents(); ob_end_clean();

$order_link = wpj_get_job_order( 'id', ['pid' => $pid], 'var' );

if ( $order_link ) {
	$order_link = '<a href="' . wpj_get_order_link( $order_link, '', 'job_purchase' ) . '">' . wpj_translate_custom_offer_title( get_the_title(), $pid ) . '</a>';

} else {
	$order_link = wpj_translate_custom_offer_title( get_the_title(), $pid );

}

/* Table body */
$table_content = array(
	'<h4 class="service-title">' . $order_link . '</h4>',
	$price,
	$max_days,
	$action,
	$subject
);

/* Display table */
wpj_display_table( '', $table_header, $table_content );