<div class="ui card generic-card js-request-item-content-<?php echo $post_id; ?>" id="request-<?php echo $post_id; ?>">

	<div class="generic-card-header">

		<div class="user-photo">

			<?php wpj_display_user_photo( array( 'uid' => $post->post_author, 'width' => 60, 'height' => 60 ) ); ?>

		</div>

		<div class="user-content">

			<a class="user-link" href="<?php echo wpj_get_user_profile_link( get_the_author_meta( 'user_login' ) ); ?>"><?php echo wpj_get_user_display_type( $post->post_author ); ?></a>

			<div class="card-date">

				<?php wpj_display_request_post_date( $post_id ); ?>

			</div>

		</div>

		<?php if ( wpj_get_option( 'wpjobster_request_lets_meet' ) == 'yes' && get_post_meta( $post_id, 'request_lets_meet', true ) == 'yes' ) { ?>

			<span class="lets-meet lets-meet-request" data-tooltip="<?php _ex( "Let's meet", "Request Section", "wpjobster" ); ?>" data-position="left center" data-inverted="">

				<?php if ( ! empty( $jobster_design['lets_meet_rich_icon_options_request']['url'] ) ) { ?>

					<img src="<?php echo $jobster_design['lets_meet_rich_icon_options_request']['url']; ?>" alt="lets-meet">

				<?php } else { ?>

					<img src="<?php echo get_template_directory_uri() . '/assets/images/card/shake-icon.png'; ?>" alt="lets-meet">

				<?php } ?>

			</span>

		<?php } ?>

	</div>

	<div class="generic-card-content">

		<a href="<?php echo get_permalink(); ?>" class="generic-card-title-link"><?php echo get_the_title(); ?></a>

		<div class="generic-card-categories">
			
			<?php wpj_display_variable( array(
				'label' => __( 'Posted in', 'wpjobster' ),
				'value' => 'wpj_display_request_category'
			) ); ?>

		</div>

	</div>

	<div class="generic-card-footer">

		<div class="start-content">

			<div class="budget">

				<?php wpj_display_variable( array(
						'label' => __( 'Budget:', 'wpjobster' ),
						'value' => 'wpj_display_request_budget'
					) ); ?>

			</div>

		</div>

		<div class="end-content">

			<a href="<?php echo get_permalink(); ?>" class="text-button text-button-secondary text-button-medium"><?php _e( 'View More', 'wpjobster' ); ?></a>

		</div>

	</div>

</div>