<?php

/* Table header */
$table_header = array(
	__( 'Request Details', 'wpjobster' ) => 'six',
	__( 'Offers received', 'wpjobster' ) => 'two',
	__( 'Date'           , 'wpjobster' ) => $active_tab == 'assigned' || $active_tab == 'completed' ? 'three' : 'five'
);

if ( $active_tab == 'assigned' ) $table_header[__( 'Assigned to', 'wpjobster' )] = 'two';

if ( $active_tab == 'completed' ) $table_header[__( 'Completed by', 'wpjobster' )] = 'two';

$table_header[__( 'Status', 'wpjobster' )] = 'three';

/* Request options */
ob_start(); ?>

<!-- Request title -->
<h4 class="service-title"><a href="<?php the_permalink(); ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h4>

<ul class="service-action-buttons">

	<!-- Edit button -->
	<li><a class="text-button text-button-small text-button-gray" href="<?php echo add_query_arg( array( 'requestid' => $pid, 'action' => 'edit-request' ), get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) ) ); ?>" class="edit_request"><?php _e( 'Edit', 'wpjobster' ); ?></a></li>

	<!-- Activate/Deactivate button -->
	<li><a class="text-button text-button-small text-button-gray <?php echo $btn_class; ?>" data-id="<?php echo $pid; ?>" data-title="<?php the_title(); ?>"><?php echo get_post_meta( $pid, 'active', true ) != '0' ? __( 'Deactivate', 'wpjobster' ) : __( 'Activate', 'wpjobster' ); ?></a></li>

	<!-- Delete button -->
	<li><a class="text-button text-button-small text-button-gray js-delete-request-link" data-id="<?php echo $post->ID; ?>" data-title-request="<?php the_title(); ?>"><?php _e( 'Delete', 'wpjobster' ); ?></a></li>

</ul>

<!-- Pending review info -->
<?php if ( $post->post_status == "pending" ) { ?>

	<span class="under-review-warning"><?php _e( 'Please edit the request following the provided instructions.', 'wpjobster' ); ?></span>

<?php }

$request_options = ob_get_contents(); ob_end_clean();

/* Table body */
$table_content = array(
	$request_options,
	'<a href="' . get_permalink( $pid ) . '">' . wpj_get_user_offers_received( $pid, get_current_user_id(), 'count' ) . '</a>',
	get_the_date( wpj_get_option( 'date_format' ) ),
);

if ( $active_tab == 'assigned' )
	$table_content[] = '<a href="' . ( get_post_meta( $pid, 'assigned_order', true ) ? wpj_get_order_link( get_post_meta( $pid, 'assigned_order', true ) ) : '#' ) . '">' . wpj_get_user_name_by_id( get_post_meta( $pid, 'assigned_to', true ), 'username' ) . '</a>';

if ( $active_tab == 'completed' )
	$table_content[] = '<a href="' . ( get_post_meta( $pid, 'assigned_order', true ) ? wpj_get_order_link( get_post_meta( $pid, 'assigned_order', true ) ) : '#' ) . '">' . wpj_get_user_name_by_id( get_post_meta( $pid, 'assigned_to', true ), 'username' ) . '</a>';

$table_content[] = '<div class="my-account-service-status"><span class="oe-status-btn ' . $class . '">' . $text . '</span></div>';

/* Display table */
wpj_display_table( 'js-request-item-content-' . $post->ID, $table_header, $table_content );