<div class="ui modal smaller custom-offer-container <?php echo $unique_id; ?>">

	<i class="close icon"></i>

	<div class="ui icon header">

		<?php if ( $is_error ) { ?>

			<i class="remove circle red icon"></i><?php _e( 'You\'re not allowed to send custom offer', 'wpjobster' );

		} else { ?>

			<i class="file text outline inverted grey icon"></i><?php echo $title;

		} ?>

	</div>

	<div id="custom-offer-wrapper <?php echo $pid; ?>" class="content custom-offer-wrapper" data-unique-id="<?php echo $unique_id; ?>" data-pid="<?php echo $pid; ?>" data-page="<?php echo $page; ?>">

		<div class="custom-offer-content <?php echo $page . ' ' . $pid; ?>">

			<?php if ( $is_error ) { ?>

				<h4 class="center">

					<?php _e( 'You need to have at least one active job in order to send custom offers.<br /><br />If you want to post a job, click ', 'wpjobster' ); ?>

					<a href="<?php echo get_permalink( wpj_get_option( 'wpjobster_post_new_page_id' ) ); ?>"><?php _e( 'here', 'wpjobster' ); ?>.</a>

				</h4>

			<?php } else { ?>

				<div class="custom-offers-default-container">

					<?php if ( is_user_logged_in() ) { ?>

						<form action="javascript://" name="offerform" class="ui form offer_form">

							<?php if ( $offer_description ) { ?>

								<div class="field">

									<textarea name="content" rows="5" placeholder="<?php _e( 'Description', 'wpjobster' ); ?>" class="offer_description"></textarea>

								</div>

							<?php } ?>

							<input type="hidden" name="token" value="<?php echo wp_create_nonce( 'new-custom-offer-send' ); ?>" />

							<?php if ( $extra && $oid ) { ?>

								<input type="hidden" name="custom_extra_form" value="true" />
								<input type="hidden" name="oid" value="<?php echo $oid; ?>" />

							<?php } ?>

							<input type="hidden" name="user" value="<?php echo $post_author_id; ?>" />
							<input type="hidden" name="pid" value="<?php echo $pid; ?>" />
							<input type="hidden" name="oid" value="<?php echo $oid; ?>" />
							<input type="hidden" name="extra" value="<?php echo $extra; ?>" />
							<input type="hidden" name="page" value="<?php echo $page; ?>" />

							<?php if ( $offer_price || $offer_days ) { ?>

								<div class="field">

									<?php if ( $offer_price && $offer_days ) { ?>

										<div class="two fields">

											<div class="field">
												<label><?php _e( 'Price', 'wpjobster' ); ?></label>
												<input type="number" step="0.01" name="price" placeholder="<?php echo wpj_show_price_classic( $price_min, 1 ) . ' - ' . wpj_show_price_classic( $price_max, 1 ); ?>" />
											</div>

											<div class="field">
												<label><?php _e( 'Days', 'wpjobster' ); ?></label>
												<input type="number" name="delivery" placeholder="1-<?php echo wpj_get_option( 'wpjobster_request_max_delivery_days' ); ?>" />
											</div>

										</div>

									<?php } else {

										if ( $offer_price ) { ?>

											<label><?php _e( 'Price', 'wpjobster' ); ?></label>
											<input type="number" step="0.01" name="price" placeholder="<?php echo wpj_show_price_classic( $price_min, 1 ) . ' - ' . wpj_show_price_classic( $price_max, 1 ); ?>" />

										<?php } elseif ( $offer_days ) { ?>

											<label><?php _e( 'Days', 'wpjobster' ); ?></label>
											<input type="number" name="delivery" placeholder="1-<?php echo wpj_get_option( 'wpjobster_request_max_delivery_days' ); ?>" />

										<?php }
									} ?>

								</div>

							<?php }

							do_action( 'wpj_before_custom_extra_submit_button', $oid, $extra ); ?>

							<div class="actions">

								<button class="ui positive uppercase labeled icon button offer_button custom-offer-btn custom-offer" type="submit" name="offer">

									<?php if ( $extra )
										echo apply_filters( 'wpj_submit_custom_extra_string_filter', __( 'Submit Custom Extra', 'wpjobster' ) );

									else
										_e( 'Submit Custom Offer', 'wpjobster' ); ?>

									<i class="white checkmark icon"></i>

								</button>

							</div>

						</form>

					<?php } else {

						_e( "Not logged in", "wpjobster" );

					} ?>

				</div>

			<?php } ?>

		</div>

	</div>

</div>