<div class="ui modal smaller request-extended-delivery-time modal-content-extended-delivery-time">

	<i class="close icon"></i>

	<div class="ui icon header">

		<i class="clock outline inverted grey icon"></i>

		<?php _e( 'Request Extended Delivery Time', 'wpjobster' ); ?>

	</div>

	<div class="content">

		<div class="ui form">

			<?php if ( wpj_get_seller_id( $order ) == get_current_user_id() ) { ?>

				<div class="field">

					<label><?php _e( 'Message', 'wpjobster' ); ?></label>

					<textarea rows="4" id="extended_days_message" name="extended_days_message" cols="40" placeholder="<?php _e( 'Your message to buyer', 'wpjobster' ); ?>"></textarea>

				</div>

				<div class="field">

					<label><?php _e( 'Days number', 'wpjobster' ); ?></label>

					<select id="extended_days_selector" name="extended_days_selector" class="ui dropdown">

						<?php for ( $i_count = 1; $i_count <= wpj_get_option( 'wpjobster_job_max_delivery_days' ); $i_count++ ) { ?>

							<option value="<?php echo $i_count; ?>">

								<?php echo sprintf( _n( '%d day', '%d days', $i_count, 'wpjobster' ), $i_count ); ?>

							</option>

						<?php } ?>

					</select>

				</div>

			<?php }

			wpj_display_extend_delivery_not_allowed_notice( $orderid ); ?>

		</div>

	</div>

	<?php if ( wpj_get_seller_id( $order ) == get_current_user_id() ) { ?>

		<div class="actions">

			<button onclick="clickAndDisable(this);" class="ui green labeled icon button js-request-extended-delivery-time">

				<?php _e( 'Confirm', 'wpjobster' ); ?>

				<i class="white checkmark icon"></i>

			</button>

			<button class="ui cancel labeled icon button">

				<?php _e( 'Cancel', 'wpjobster' ); ?>

				<i class="close icon"></i>

			</button>

		</div>

	<?php } ?>

</div>