<div class="ui modal smaller request-mutual-cancellation modal-content-cancellation">

	<i class="close icon"></i>

	<div class="ui icon header">

		<i class="file excel outline red icon"></i>

		<?php _e( 'Request Mutual Cancellation', 'wpjobster' ); ?>

	</div>

	<div class="content">

		<div class="ui form">

			<?php if ( wpj_get_seller_id( $order ) == get_current_user_id() ) { ?>

				<div class="field">
					<p><?php _e( 'You are about to request cancellation for this job. By using this option you are asking the buyer to mutually cancel the order. If he agrees, and cancels the order, the money gets refunded into his account and you will not get a bad review over it.', 'wpjobster' ); ?></p>
				</div>

				<div class="field">
					<textarea rows="4" id="message_to_buyer" name="message_to_buyer" cols="40" required="required" placeholder="<?php _e( 'Your message to the buyer: ', 'wpjobster' ); ?>"></textarea>
					<input type="hidden" id="process_action" value="confirm_cancellation_from_seller" name="process_action" />
				</div>

			<?php } elseif ( $order->uid == get_current_user_id() ) { ?>

				<div class="field">
					<p><?php _e( 'You are about to request cancellation for this job. By using this option you are asking the seller to mutually cancel the order. If he agrees, and cancels the order, the money gets refunded into your account and you will not get a bad review over it.', 'wpjobster' ); ?></p>
				</div>

				<div class="field">
					<textarea rows="4" id="message_to_buyer" name="message_to_buyer" cols="40" required="required" placeholder="<?php _e( 'Your message to the seller:', 'wpjobster' ); ?>"></textarea>
					<input type="hidden" id="process_action" value="confirm_cancellation_from_buyer" name="process_action" />
				</div>

			<?php } else { ?>

				<div class="field">
					<p><?php _e( 'You are not allowed to cancel this order.', 'wpjobster' ); ?></p>
				</div>

			<?php } ?>

		</div>

	</div>

	<?php if ( wpj_get_seller_id( $order ) == get_current_user_id() || $order->uid == get_current_user_id() ) { ?>

		<div class="actions">

			<button onclick="clickAndDisable(this);" class="ui green labeled icon button js-request-cancellation">

				<?php _e( 'Confirm', 'wpjobster' ); ?>

				<i class="white checkmark icon"></i>

			</button>

			<button class="ui cancel labeled icon button">

				<?php _e( 'Cancel', 'wpjobster' ); ?>

				<i class="close icon"></i>

			</button>

		</div>

	<?php } ?>

</div>