<div class="ui modal smaller resolution-center modal-content-resolution-center">

	<i class="close icon"></i>

	<div class="ui icon header">

		<i class="handshake outline inverted grey icon"></i>

		<?php _e( 'Resolution Center', 'wpjobster' ); ?>

	</div>

	<div class="content">

		<div class="ui form">

			<div class="grouped fields">

				<?php if ( $cancellation_count < wpj_get_option( 'wpjobster_number_of_cancellations' ) ) { ?>

					<div class="field">
						<div class="ui radio checkbox">
							<input type="radio" name="resolution_center_option" value="cancellation">
							<label><?php _e( 'Request mutual cancellation', 'wpjobster' ); ?></label>
						</div>
					</div>

				<?php } ?>

				<div class="field">
					<div class="ui radio checkbox">
						<input type="radio" name="resolution_center_option" value="arbitration">
						<label><?php _e( 'Request arbitration', 'wpjobster' ); ?></label>
					</div>
				</div>

				<?php if (
					wpj_get_seller_id( $order ) == get_current_user_id()
					&& wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no'
					&& get_post_meta( $order->pid, 'instant', true ) != 1
					&& ! wpj_get_extended_delivery_order( 'id', ['order_id' => $order->id, 'status' => 0], 'var' )
				) { ?>

					<div class="field">
						<div class="ui radio checkbox">
							<input type="radio" name="resolution_center_option" value="extended_delivery_time">
							<label><?php _e( 'Request extended delivery time', 'wpjobster' ); ?></label>
						</div>
					</div>

				<?php } ?>

			</div>
		</div>

	</div>

	<div class="actions">

		<button class="ui green labeled icon button js-resolution-center-option">

			<?php _e( 'Next', 'wpjobster' ); ?>

			<i class="white checkmark icon"></i>

		</button>

		<button class="ui cancel labeled icon button">

			<?php _e( 'Cancel', 'wpjobster' ); ?>

			<i class="close icon"></i>

		</button>

	</div>

</div>