<?php if ( wpj_get_option( 'wpjobster_enable_user_transactions_export' ) != 'no' ) { ?>

	<div class="ui modal smaller center js-export-user-transactions-modal">

		<i class="close icon"></i>

		<div class="ui icon header">

			<i class="inverted grey check circle outline icon"></i>

			<div class="title-modal">

				<?php _e( 'Export TRANSACTIONS', 'wpjobster' ); ?>

			</div>

		</div>

		<div class="center content">

			<form class="ui form">

				<div class="two fields">
					<div class="field">
						<label><?php _e( 'Start date', 'wpjobster' ); ?></label>
						<div class="ui calendar js-calendar js-transactions-start-date-input" data-page="export_transactions" data-datetype="datetime">
							<div class="ui input left icon">
								<i class="calendar alternate outline icon"></i>
								<input type="text" placeholder="<?php _e( 'Insert the start date or choose one of the options below', 'wpjobster' ); ?>" name="transactions_start_date" class="js-transactions-start-date">
							</div>
						</div>
					</div>

					<div class="field">
						<label><?php _e( 'End date', 'wpjobster' ); ?></label>
						<div class="ui calendar js-calendar js-transactions-end-date-input" data-page="export_transactions" data-datetype="datetime">
							<div class="ui input left icon">
								<i class="calendar alternate outline icon"></i>
								<input type="text" placeholder="<?php _e( 'Insert the end date or choose one of the options below', 'wpjobster' ); ?>" name="transactions_end_date" class="js-transactions-end-date">
							</div>
						</div>
					</div>
				</div>

				<?php if ( $intervals ) { ?>

					<div class="field">
						<div class="ui labels js-transacations-export-intervals">

							<?php foreach ( $intervals as $key => $interval ) { ?>

								<div class="ui cursor-pointer label" data-start-date="<?php echo $intervals[$key]['start_date']; ?>" data-end-date="<?php echo $intervals[$key]['end_date']; ?>">

									<?php echo $intervals[$key]['name']; ?>

								</div>

							<?php } ?>

						</div>
					</div>

				<?php } ?>

				<input type="hidden" class="js-user-id" value="<?php echo $uid; ?>" />
				<input type="hidden" class="js-user-name" value="<?php echo $uname; ?>" />

			</form>

		</div>

		<div class="center actions">

			<div class="ui green labeled icon button js-export-user-transactions-action">

				<i class="white checkmark icon"></i>

				<?php _e( 'Export', 'wpjobster' ); ?>

			</div>

			<div class="ui labeled icon cancel button">

				<i class="remove icon"></i>

				<?php _e( 'Cancel', 'wpjobster' ); ?>

			</div>

		</div>

	</div>

<?php } else echo '<style>.js-export-user-transactions-link{display:none;}</style>'; // for page builder