<div class="ui modal center up-certification-modal-wrapper <?php echo $indx; ?>">

	<i class="close icon"></i>

	<div class="ui icon header">

		<i class="certificate inverted grey icon"></i>

		<span class="add-or-edit-title"><?php _e( 'Add or edit', 'wpjobster' ); ?></span>&nbsp;<?php _e( 'certification', 'wpjobster' ); ?>

	</div>

	<div class="scrolling content">

		<div class="up-certification-modal-main-content">

			<form data-type="certification" action="javascript://" name="modal_form" class="ui form modal_form">

				<div class="field certification_name">
					<label><?php _e( 'Certification name', 'wpjobster' ); ?><span class="red"> * </span></label>
					<input type="text" name="user_certification_name" placeholder="<?php _e( 'Ex: CFA', 'wpjobster' ); ?>" value="<?php echo htmlentities( $certification_name ); ?>" />
				</div>

				<div class="field certification_authority">
					<label><?php _e( 'Certification authority', 'wpjobster' ); ?></label>
					<input type="text" name="user_certification_authority" value="<?php echo htmlentities( $certification_authority ); ?>" />
				</div>

				<div class="field license_number">
					<label><?php _e( 'License number', 'wpjobster' ); ?></label>
					<input type="text" name="user_license_number" value="<?php echo htmlentities( $license_number ); ?>" />
				</div>

				<div class="two fields">

					<div class="field ufrom_month">
						<label><?php _e( 'From Month', 'wpjobster' ); ?></label>
						<select name="user_from_month" class="ui dropdown user_from_month">
							<option value=""><?php _e( 'From Month', 'wpjobster' ); ?></option>

							<?php for ( $i = 1; $i <= 12; $i++ ) { ?>

								<option <?php echo wpj_get_selected_value( $from_month, $i ); ?> value="<?php echo $i; ?>"><?php echo wpj_date_number_to_string( $i ); ?></option>

							<?php } ?>

						</select>
					</div>

					<div class="field to_month">
						<label><?php _e( 'To Month', 'wpjobster' ); ?></label>
						<select name="user_to_month" class="ui dropdown user_to_month">
							<option value=""><?php _e( 'To Month', 'wpjobster' ); ?></option>

							<?php for ( $i = 1; $i <= 12; $i++ ) { ?>

								<option <?php echo wpj_get_selected_value( $to_month, $i ); ?> value="<?php echo $i; ?>"><?php echo wpj_date_number_to_string( $i ); ?></option>

							<?php } ?>

						</select>
					</div>

				</div>

				<div class="two fields">

					<div class="field from_year">
						<label><?php _e( 'From Year', 'wpjobster' ); ?></label>
						<select name="user_from_year" class="ui dropdown user_from_year">
							<option value=""><?php _e( 'From Year', 'wpjobster' ); ?></option>

							<?php for ( $i = date( 'Y' ); $i >= 1900; $i-- ) { ?>

								<option <?php echo wpj_get_selected_value( $from_year, $i ); ?> value="<?php echo $i; ?>"><?php echo $i; ?></option>

							<?php } ?>

						</select>
					</div>

					<div class="field to_year">
						<label><?php _e( 'To Year (or expected)', 'wpjobster' ); ?></label>
						<select name="user_to_year" class="ui dropdown user_to_year">
							<option value=""><?php _e( 'To Year', 'wpjobster' ); ?></option>

							<?php for ( $i = date( 'Y', strtotime( '+10 years' ) ); $i >= 1900; $i-- ) { ?>

								<option <?php echo wpj_get_selected_value( $to_year, $i ); ?> value="<?php echo $i; ?>"><?php echo $i; ?></option>

							<?php } ?>

						</select>
					</div>

				</div>

				<div class="field certification_not_expire">
					<div class="ui checkbox certification-not-expire">
						<input type="checkbox" name="user_certification_not_expire" <?php echo $certification_not_expire == 'on' ? 'checked=checked' : ''; ?> />
						<label><?php _e( 'This certification does not expire', 'wpjobster' ); ?></label>
					</div>
				</div>


				<div class="field certification_url">
					<label><?php _e( 'Certification URL', 'wpjobster' ); ?></label>
					<input type="text" name="user_certification_url" value="<?php echo htmlentities( $certification_url ); ?>" />
				</div>

				<input type="hidden" value="<?php echo $indx; ?>" name="indx" />

				<input type="hidden" value="<?php echo get_current_user_id(); ?>" name="uid" />

				<div class="actions">

					<button class="ui uppercase labeled icon button save-item" type="submit">

						<?php _e( 'Save', 'wpjobster' ); ?>

						<i class="checkmark icon"></i>

					</button>

				</div>

			</form>

		</div>

	</div>

</div>