<div class="ui modal smaller center" id="vacation_mode_modal_ui">

	<?php if ( ! $user_vacation ) { ?>

		<i class="close icon"></i>

		<div class="ui header icon">

			<i class="plane inverted grey icon"></i>

			<?php _e( 'Activate Vacation Mode', 'wpjobster' ); ?>

		</div>

		<div class="content">

			<div class="ui form">

				<div class="field">
					<label><?php _e( 'Away reason', 'wpjobster' ); ?></label>
					<select class="ui fluid dropdown" name="wpjobster_vacation_away_reason" id="wpjobster_vacation_away_reason">
						<option value=""><?php _e( 'Select', 'wpjobster' ); ?></option>
						<option value="1"><?php echo wpj_get_vacation_reason( 1 ); ?></option>
						<option value="2"><?php echo wpj_get_vacation_reason( 2 ); ?></option>
						<option value="3"><?php echo wpj_get_vacation_reason( 3 ); ?></option>
					</select>
				</div>

				<div class="field cf">
					<label><?php _e( 'Start date', 'wpjobster' ); ?></label>
					<div class="ui calendar js-calendar" data-page="vacation">
						<div class="ui input left icon">
							<i class="calendar alternate outline icon"></i>
							<input type="text" placeholder="<?php _e( 'Start date', 'wpjobster' ); ?>" name="wpjobster_vacation_duration_start" id="wpjobster_vacation_duration_start">
						</div>
					</div>
				</div>

				<div class="field cf">
					<label><?php _e( 'End date', 'wpjobster' ); ?></label>
					<div class="ui calendar js-calendar" data-page="vacation">
						<div class="ui input left icon">
							<i class="calendar alternate outline icon"></i>
							<input type="text" placeholder="<?php _e( 'End date', 'wpjobster' ); ?>" name="wpjobster_vacation_duration_end" id="wpjobster_vacation_duration_end">
						</div>
					</div>
				</div>

			</div>

			<div class="messages"></div>

		</div>

		<div class="actions">

			<div class="ui green labeled icon button" id="vacation_mode_yes">

				<?php _e( 'Activate', 'wpjobster' ); ?>

				<i class="white checkmark icon"></i>

			</div>

			<div class="ui cancel labeled icon button">

				<?php _e( 'Cancel', 'wpjobster' ); ?>

				<i class="close icon"></i>

			</div>

		</div>

	<?php } else { ?>

		<i class="close icon"></i>

		<div class="ui header icon">

			<i class="plane inverted grey icon"></i>

			<?php _e( 'Deactivate Vacation Mode', 'wpjobster' ); ?>

		</div>

		<div class="content">
			<div class="ui form">

				<div class="field">
					<label><?php _e( 'Away reason', 'wpjobster' ); ?></label>
					<input placeholder="<?php echo $user_vacation['reason']; ?>" readonly="" type="text">
				</div>

				<div class="field cf">
					<label><?php _e( 'Start date', 'wpjobster' ); ?></label>
					<input placeholder="<?php echo wpj_date( wpj_get_option( 'date_format' ), $user_vacation['start'], false ); ?>" readonly="" type="text">
				</div>

				<div class="field cf">
					<label><?php _e( 'End date', 'wpjobster' ); ?></label>
					<input placeholder="<?php echo wpj_date( wpj_get_option( 'date_format' ), $user_vacation['end'], false ); ?>" readonly="" type="text">
				</div>

			</div>

			<div class="messages"></div>

		</div>

		<div class="actions">

			<div class="ui red labeled icon button" id="vacation_mode_no">

				<?php _e( 'Deactivate', 'wpjobster' ); ?>

				<i class="white checkmark icon"></i>

			</div>

			<div class="ui cancel labeled icon button">

				<?php _e( 'Cancel', 'wpjobster' ); ?>

				<i class="close icon"></i>

			</div>

		</div>

	<?php } ?>

</div>