<?php if ( function_exists( 'have_rows' ) && have_rows( 'job_fields', wpj_get_option( 'wpjobster_post_new_page_id' ) ) ) {

	if ( ! $use_tabs ) { ?>

		<div class="post-new-wrapper post-new-job-wrapper ui grid gray-background-full full-width-container">

			<?php if ( WPJ_Form::get( 'action' ) == 'edit-job' )
				wpj_display_title( array( 'title' => sprintf( __( 'Edit Job - %s', 'wpjobster' ), $post->post_title ), 'icon' => 'edit' ) );

			else
				wpj_display_title( array( 'title' => __( 'Post New Job', 'wpjobster' ), 'icon' => 'edit' ) ); ?>

		</div>

	<?php } ?>

	<div class="page_without_sidebar full-width-container">

		<?php if ( WPJ_Form::get( 'action' ) != 'edit-job' || ( WPJ_Form::get( 'action' ) == 'edit-job' && $post->post_author == get_current_user_id() ) ) {

			wpj_display_job_post_new_notices(); ?>

			<!-- Tabs -->
			<form id="add-edit-job-form" class="ui form" method="post" enctype="multipart/form-data">

				<?php wpj_display_message( array( 'message_class' => 'error mt0', 'is_hidden' => false ) ); ?>

				<div class="<?php echo $class; ?>">

					<?php wp_nonce_field( 'post_new_or_edit_job_action', 'post_new_or_edit_job_field' ); ?>

					<div class="post-new-wrapper post-new-job-wrapper">
						<div class="tabs-wrapper js-tabs-wrapper">

							<?php if ( $use_tabs && $last_tab > 0 ) { ?>

								<div class="ui grid gray-background-full">
									<div class="main-content no-padding vertical-align-middle">
										<div class="ui <?php echo $last_tab_str; ?> small unstackable steps">

											<?php foreach ( $job_fields as $job_tab ) {

												if ( $use_tabs && $tab_no > 0 ) { ?>

													<div class="step <?php echo $tab_no == 1 ? 'active' : ''; ?>" id="tab<?php echo $tab_no; ?>">
														<i class="<?php echo $job_tab['icon'] != '' ? $job_tab['icon'] : 'info'; ?> icon"></i>
														<div class="content">
															<div class="title"><span class="tab-title"><?php echo $job_tab['label']; ?></span></div>
															<div class="description"><?php echo $job_tab['description']; ?></div>
														</div>
													</div>

												<?php } $tab_no++;

											} ?>

										</div>
									</div>
								</div>

								<!-- General instructions -->
								<?php if ( function_exists( 'get_field' ) && get_field( 'general_instructions' ) || current_user_can( 'manage_options' ) ) { ?>

									<div class="ui segment general-instruction-box">

										<?php if ( function_exists( 'get_field' ) && get_field( 'general_instructions', wpj_get_option( 'wpjobster_post_new_page_id' ) ) )
											echo get_field( 'general_instructions', wpj_get_option( 'wpjobster_post_new_page_id' ) );

										elseif ( current_user_can( 'manage_options' ) )
											_e( 'Regular users will not see this message unless you edit it from WP Admin > Pages > Post New or Edit Job > General Tooltip Instructions.', 'wpjobster' ); ?>

									</div>

								<?php }

							}

							// Display tab content
							foreach ( $job_fields as $job_tab ) {

								if ( $tab_number == 1 ) { ?>

									<div class="tab-wrapper js-tab-wrapper">

								<?php }

										if ( $use_tabs && $tab_number > 0 ) { ?>

											<div class="<?php echo $tab_number == 1 ? 'tab active' : 'tab'; ?>">

										<?php }

												if ( $job_tab['tab_fields'] ) {

													foreach ( $job_tab['tab_fields'] as $j_field ) { $field_content_arr = $JobsNewEditClass->getFieldsContent( $j_field );

														if ( $j_field && isset( $j_field['acf_fc_layout'] ) ) {

															if ( strpos( $j_field['acf_fc_layout'], 'custom_field' ) !== false && isset( $j_field['slug'] ) ) {

																$unique_slug = 'job_cfield_' . $j_field['slug'];

															} else {

																$unique_slug = $j_field['acf_fc_layout'];

															}

														} else {

															$unique_slug = '';

														}

														if ( $j_field['width'] == 'third' ) $class_name = 'three';
														elseif ( $j_field['width'] == 'half' || $j_field['width'] == 'half-solo' ) $class_name = 'two';
														else $class_name = 'one';

														if ( $j_field['width'] == 'full'
															|| $j_field['width'] == 'half-solo'
															|| ( $j_field['width'] == 'half' && $ji == 0 )
															|| ( $j_field['width'] == 'third' && $ti == 0 )
														) { ?>

															<div class="<?php echo $field_content_arr['parent_class'] . ' ' . $class_name; ?> fields">

														<?php } ?>

																<div id="<?php echo $field_content_arr['id']; ?>" class="<?php echo $field_content_arr['class']; ?> field">

																	<?php if ( $field_content_arr['label'] != 'no' ) { ?>

																		<label><?php echo $j_field['label']; ?></label>

																	<?php }

																	echo $field_content_arr['content']; ?>

																</div>

																<?php if ( $field_content_arr['popup'] != 'no' ) {

																	if ( $action_type == 'edit-job' ) {

																		wpj_display_popup_content( $field_content_arr['instr'], 'edit', 'job', $pid, $field_content_arr['f_rej_name'], $j_field );

																	} else {

																		wpj_display_popup_content( $field_content_arr['instr'], 'new', 'job', $pid, '', $j_field );

																	}

																}

																if ( $j_field['width'] == 'half' ) $ji++;
																if ( $j_field['width'] == 'third' ) $ti++;

															if ( $j_field['width'] == 'half-solo' ) { ?>

																<div class="field"></div>

															<?php } elseif ( $j_field['width'] == 'half' && $ji == 2 ) { ?>

																</div><?php $ji = 0;

															} elseif ( $j_field['width'] == 'third' && $ti == 3 ) { ?>

																</div><?php $ti = 0;

															}

														if ( $j_field['width'] == 'full' || $j_field['width'] == 'half-solo' ) { ?>

															</div>

														<?php }

													}

													if ( $tab_number == $last_tab ) { ?>

														<input id="aoe_form_submitted" name="aoe_form_submitted" type="submit" value="<?php echo WPJ_Form::get( 'action' ) == 'edit-job' ? __( 'Save', 'wpjobster' ) : __( 'Publish', 'wpjobster' ) ?>" class="ui primary submit button post-new-job-btn" />

													<?php }

												}

												if ( $use_tabs && $tab_number > 0 ) { ?>

													<div class="tab-corner-image">
														<img src="<?php echo $job_tab['image']; ?>" alt="">
													</div>

													<?php if ( $tab_number > 1 ) { ?>

														<div class="tab-controls">
															<a href="#" class="left prev-button"><?php echo $job_fields[$tab_number - 1]['label']; ?></a>
														</div>

													<?php }

													if ( $tab_number < $last_tab ) { ?>

														<div class="tab-controls">
															<a href="#" class="ui right floated next-button button"><?php echo $job_fields[$tab_number + 1]['label']; ?></a>
														</div>

													<?php }

												}

										if ( $use_tabs && $tab_number > 0 ) { ?>

											</div>

										<?php }

								if ( $use_tabs && $tab_number > 0 && $tab_number == $last_tab ) { ?>

									</div>

								<?php } $tab_number++;

							} ?>

						</div>

					</div>

				</div>

			</form>

			<div class="ui hidden divider"></div>

		<?php } ?>

	</div>

<?php } else wpj_display_page_no_fields_warning();