<div class="single-job-wrapper" data-author="<?php echo $post->post_author; ?>" data-pid="<?php echo $pid; ?>">

	<div class="single-job-top">

		<!-- TOP -->
		<?php if ( $has_cover_image ) { ?>

			<div class="single-job-cover">

				<?php wpj_display_job_cover_image(); ?>

			</div>

		<?php } ?>

	</div>

	<div class="single-job-grid">

		<!-- LEFT SIDE -->
		<div class="single-job-body">

			<div class="single-job-slider">

				<div class="middle aligned">

					<!-- Category -->
					<div class="row">
						<div class="eight wide column"><?php wpj_display_post_category_and_subcategory( $pid, 'job_cat' ); ?></div>
					</div>

					<!-- Title -->
					<div class="row">
						<div class="sixteen wide column"><?php wpj_display_title( array( 'title_class' => 'job-title-wrapper' ) ); ?></div>
					</div>

					<!-- Rating & Queue & Delivery -->
					<div class="single-job-overview df flex-thumb-text">

						<div class="single-job-overview-left">
							<div class="single-job-overview-thumb">

								<?php wpj_display_user_photo( array(
									'uid'              => $post->post_author,
									'width'            => 44,
									'height'           => 44,
									'with_level_image' => false,
									'with_link'        => false,
									'img_class'        => 'single-job-overview-user-image'
								) );

								wpj_display_user_status_icon(
									$post->post_author,
									'yes_with_icon', false
								); ?>

							</div>
						</div>

						<div class="single-job-overview-center">
							<div class="single-job-overview-username row df">

								<?php wpj_display_username_as_link( $post->post_author ); ?>
								<?php wpj_display_user_info_icons( $post->post_author, array( 'status' => 'no' ) ); ?>

							</div>

							<div class="single-job-overview-details row df">
								<div><?php wpj_display_user_level_label( $post->post_author ); ?></div>
								<div><?php wpj_display_seller_reputation( $post->post_author, $pid ); ?></div>
								<div><?php wpj_display_user_last_seen( $post->post_author, true ); ?></div>
							</div>
						</div>

						<div class="single-job-overview-right"><?php wpj_display_user_contact_button( $post->post_author, $pid, 'job' ); ?></div>

					</div>

					<!-- Images & Videos -->
					<div class="row">
						<div class="sixteen wide column"><?php wpj_display_job_carousel(); ?></div>
					</div>

				</div>

			</div>

			<!-- User Feedback Carousel -->
			<div class="job-user-reviews-carousel-wrapper">
				<div class="job-user-reviews-header">
					<h2><?php _e( 'What people loved about this seller', 'wpjobster' ); ?></h2>
					<a href="<?php echo wpj_get_user_profile_link( $post->post_author ); ?>#all-reviews-section" class="read-more"><?php _e( 'See all reviews', 'wpjobster' ); ?></a>
				</div>

				<?php wpj_display_user_reviews_carousel( $post->post_author ); ?>

			</div>

			<?php // Social Share Panel
			wpj_display_job_social_share_icons();

			// Description
			wpj_display_accordion( array(
				'segment_class'     => 'job-description-wrapper',
				'title_class'       => 'single-job-title-description',
				'title'             => __( 'Job Description', 'wpjobster' ),
				'description_class' => 'single-job-job-description',
				'description'       => 'wpj_display_job_description'
			) );

			do_action( 'wpj_after_single_job_description', $pid ); ?>

			<!-- User Info -->
			<div class="job-user-main-info-wrapper">

				<div class="job-user-main-info-header">

					<!-- User Logo and Level Image -->
					<div class="user-img-container">

						<?php wpj_display_user_photo( array( 'uid' => $post->post_author, 'width' => 130, 'height' => 130, 'with_level_image' => true, 'link_class' => 'user-avatar-image-link' ) ); ?>

					</div>

					<div class="user-info">

						<div class="user-info-header">

							<div class="start">

								<?php // Username
								wpj_display_username_as_link( $post->post_author );

								// User Badges
								wpj_display_user_info_icons( $post->post_author );

								// User Type
								wpj_display_user_account_type( $post->post_author );

								// User Rating
								wpj_display_user_rating_info( $post->post_author ); ?>

							</div>

							<div class="end">

								<?php // Contact Button
								wpj_display_user_contact_button( $post->post_author, $pid, 'job' ); ?>

							</div>

						</div>

						<div class="meta-columns-wrapper">

							<div class="meta-column">
								<div class="label-class"><?php _e( 'From', 'wpjobster' ); ?>:</div>
								<div class="value-class"><?php wpj_display_user_country( $post->post_author ); ?></div>
							</div>

							<div class="meta-column">
								<div class="label-class"><?php _e( 'Last Seen', 'wpjobster' ); ?>:</div>
								<div class="value-class"><?php wpj_display_user_last_seen( $post->post_author, false ); ?></div>
							</div>

							<div class="meta-column">
								<div class="label-class"><?php _e( 'Member Since', 'wpjobster' ); ?>:</div>
								<div class="value-class"><?php wpj_display_user_registration_date( $post->post_author ); ?></div>
							</div>

						</div>

						<div class="user-descriptions">

							<!-- User Description -->
							<?php wpj_display_user_description( $post->post_author );

							do_action( 'wpj_after_user_profile_description', $pid ); ?>

						</div>

					</div>
				</div>

			</div>

			<?php
			// Instructions
			wpj_display_accordion( array(
				'segment_class'     => 'job-instructions-wrapper',
				'title_class'       => 'single-job-title-description',
				'title'             => __( 'Instructions', 'wpjobster' ),
				'description_class' => 'single-job-buyer-instructions',
				'description'       => 'wpj_display_buyer_instructions'
			) );

			// FAQ
			wpj_display_accordion( array(
				'segment_class'     => 'job-faq-wrapper',
				'title_class'       => '',
				'title'             => __( 'FAQ', 'wpjobster' ),
				'description_class' => 'single-job-faq',
				'description'       => 'wpj_display_job_faq'
			) );

			// Audio
			wpj_display_accordion( array(
				'segment_class'     => 'job-audio-wrapper',
				'title_class'       => 'single-job-jp-title',
				'title'             => __( 'Audio', 'wpjobster' ),
				'description_class' => 'audio-margin-bottom-helper audio-embed-wrapper',
				'description'       => 'wpj_display_job_audio'
			) );

			// Preview
			wpj_display_accordion( array(
				'segment_class'     => 'job-preview-wrapper',
				'title_class'       => 'single-job-preview-title',
				'title'             => __( 'Job Preview', 'wpjobster' ),
				'description_class' => 'file-to-download cf',
				'description'       => 'wpj_display_job_preview'
			) );

			// Map
			wpj_display_accordion( array(
				'segment_class'     => 'job-map-wrapper',
				'title_class'       => 'single-job-map-title',
				'title'             => __( 'Map', 'wpjobster' ),
				'description_class' => '',
				'description'       => 'wpj_display_job_map'
			) );

			// Custom Fields
			wpj_display_job_custom_fields();

			// Compare Packages
			wpj_display_job_packages( $pid );

			// Order Additional
			wpj_display_job_order_form( $pid );

			// Reviews
			wpj_display_accordion( array(
				'segment_class'     => 'single-job-review-wrapper',
				'title_class'       => 'single-job-feedback-title',
				'title'             => __( 'Feedback', 'wpjobster' ),
				'description_class' => 'feedbacks_box_all',
				'description'       => 'wpj_display_job_review_text'
			) );

			// Recommended Jobs
			wpj_display_accordion( array(
				'segment_class'     => 'single-job-other-job',
				'title_class'       => 'single-job-other-jobs-title',
				'title'             => sprintf( __( "Other jobs by %s", 'wpjobster' ), wpj_get_user_display_type( $user->ID ) ),
				'description_class' => '',
				'description'       => 'wpj_display_suggested_jobs_list'
			) ); ?>

		</div>

		<!-- RIGHT SIDE -->
		<div class="single-job-sidebar">

			<div class="ui sticky">

				<div class="single-job-buy">

					<?php // Packages
					wpj_display_job_packages( $pid, 'sidebar' );

					// Order Additional
					wpj_display_job_order_form( $pid, 'sidebar' ); ?>

				</div>

				<?php // Secure Info
				wpj_display_job_secure();

				// Terms Info
				wpj_display_job_terms();

				if ( $display_tags || $display_views ) { ?>

					<div class="job-tags-wrapper">

						<!-- Tags -->
						<?php if ( get_the_tags( $pid ) ) { ?>

							<h4><?php _e( "Related Topics", "wpjobster" ); ?></h4>

						<?php }

						wpj_display_job_tags( $pid ); ?>

						<!-- Views -->
						<div class="views">
							<?php wpj_display_job_views( $pid, true ); ?>
						</div>

					</div>

				<?php }

				// Sidebar Bottom Widget
				if ( is_active_sidebar( 'single-job-widgets-area' ) ) { ?>

					<div class="ui segment job-sidebar-bottom-widget-wrapper">

						<div id="single-job-widgets-area" class="primary-sidebar widget-area" role="complementary">

							<ul><?php dynamic_sidebar( 'single-job-widgets-area' ); ?></ul>

						</div>

					</div>

				<?php } ?>

			</div>

		</div>

	</div><!-- END CONTENT:  -->

</div><!-- END single-job-wrapper -->